/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.broadinstitute.variant.variantcontext.VariantContext;

class VariantJEXLContext
implements JexlContext {
    private VariantContext vc;
    private static Map<String, AttributeGetter> x = new HashMap<String, AttributeGetter>();

    public VariantJEXLContext(VariantContext variantContext) {
        this.vc = variantContext;
    }

    @Override
    public Object get(String string2) {
        Object object = null;
        if (x.containsKey(string2)) {
            object = x.get(string2).get(this.vc);
        } else if (this.vc.hasAttribute(string2)) {
            object = this.vc.getAttribute(string2);
        } else if (this.vc.getFilters().contains(string2)) {
            object = "1";
        }
        return object;
    }

    @Override
    public boolean has(String string2) {
        return this.get(string2) != null;
    }

    @Override
    public void set(String string2, Object object) {
        throw new UnsupportedOperationException("remove() not supported on a VariantJEXLContext");
    }

    static {
        x.put("vc", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext;
            }
        });
        x.put("CHROM", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getChr();
            }
        });
        x.put("POS", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getStart();
            }
        });
        x.put("TYPE", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getType().toString();
            }
        });
        x.put("QUAL", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return -10.0 * variantContext.getLog10PError();
            }
        });
        x.put("ALLELES", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getAlleles();
            }
        });
        x.put("N_ALLELES", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getNAlleles();
            }
        });
        x.put("FILTER", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.isFiltered() ? "1" : "0";
            }
        });
        x.put("homRefCount", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getHomRefCount();
            }
        });
        x.put("hetCount", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getHetCount();
            }
        });
        x.put("homVarCount", new AttributeGetter(){

            @Override
            public Object get(VariantContext variantContext) {
                return variantContext.getHomVarCount();
            }
        });
    }

    private static interface AttributeGetter {
        public Object get(VariantContext var1);
    }
}

