/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.elections.ElectionAgentThread;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class Acceptor
extends ElectionAgentThread {
    private final RepNode repNode;
    private Proposer.Proposal promisedProposal = null;
    private Protocol.Value acceptedValue = null;
    private final SuggestionGenerator suggestionGenerator;
    public static final String SERVICE_NAME = "Acceptor";

    public Acceptor(Protocol protocol, RepNode repNode, SuggestionGenerator suggestionGenerator) {
        super(repNode, protocol, "Acceptor Thread " + repNode.getNameIdPair().getName());
        this.repNode = repNode;
        this.suggestionGenerator = suggestionGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServiceDispatcher serviceDispatcher = this.repNode.getServiceDispatcher();
        serviceDispatcher.register(SERVICE_NAME, this.channelQueue);
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor started");
        SocketChannel channel = null;
        try {
            try {
                Object var10_12;
                PrintWriter out;
                BufferedReader in;
                Socket socket;
                while (true) {
                    block21: {
                        block20: {
                            block19: {
                                if ((channel = serviceDispatcher.takeChannel(SERVICE_NAME, true, this.protocol.getReadTimeout())) == null) {
                                    Object var12_13 = null;
                                    serviceDispatcher.cancel(SERVICE_NAME);
                                    this.cleanup();
                                    return;
                                }
                                socket = channel.socket();
                                in = null;
                                out = null;
                                try {
                                    try {
                                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                        out = new PrintWriter(socket.getOutputStream(), true);
                                        String requestLine = in.readLine();
                                        if (requestLine == null) {
                                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor: EOF on request");
                                            var10_12 = null;
                                            break block19;
                                        }
                                        TextProtocol.RequestMessage requestMessage = null;
                                        try {
                                            requestMessage = this.protocol.parseRequest(requestLine);
                                        }
                                        catch (TextProtocol.InvalidMessageException e) {
                                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Message format error: " + e.getMessage());
                                            Protocol protocol = this.protocol;
                                            protocol.getClass();
                                            out.println(new TextProtocol.ProtocolError(protocol, e).wireFormat());
                                            var10_12 = null;
                                            Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                            this.cleanup();
                                            continue;
                                        }
                                        TextProtocol.ResponseMessage responseMessage = null;
                                        if (requestMessage.getOp() == this.protocol.PROPOSE) {
                                            responseMessage = this.process((Protocol.Propose)requestMessage);
                                        } else if (requestMessage.getOp() == this.protocol.ACCEPT) {
                                            responseMessage = this.process((Protocol.Accept)requestMessage);
                                        } else {
                                            if (requestMessage.getOp() == this.protocol.SHUTDOWN) {
                                                break;
                                            }
                                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.SEVERE, "Unrecognized request: " + requestLine);
                                            break block20;
                                        }
                                        responseMessage.setSendVersion(requestMessage.getSendVersion());
                                        out.println(responseMessage.wireFormat());
                                        break block21;
                                    }
                                    catch (IOException e) {
                                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "IO error on socket: " + e.getMessage());
                                        var10_12 = null;
                                        Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                        this.cleanup();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var10_12 = null;
                                    Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                    this.cleanup();
                                    throw throwable;
                                }
                            }
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                            this.cleanup();
                            continue;
                        }
                        var10_12 = null;
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                        this.cleanup();
                        continue;
                    }
                    var10_12 = null;
                    Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                    this.cleanup();
                }
                var10_12 = null;
                Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                this.cleanup();
                Object var12_14 = null;
                serviceDispatcher.cancel(SERVICE_NAME);
            }
            catch (InterruptedException e) {
                if (this.isShutdown()) {
                    Object var12_15 = null;
                    serviceDispatcher.cancel(SERVICE_NAME);
                    this.cleanup();
                    return;
                }
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Acceptor unexpected interrupted");
                throw EnvironmentFailureException.unexpectedException(e);
            }
            this.cleanup();
            return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            serviceDispatcher.cancel(SERVICE_NAME);
            this.cleanup();
            throw throwable;
        }
    }

    TextProtocol.ResponseMessage process(Protocol.Propose propose) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(propose.getProposal()) > 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Propose: " + propose.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.promisedProposal = propose.getProposal();
        Protocol.Value suggestedValue = this.suggestionGenerator.get(this.promisedProposal);
        long suggestionRanking = this.suggestionGenerator.getRanking(this.promisedProposal);
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Suggested Value: " + suggestedValue + " Suggestion Ranking: " + suggestionRanking);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Promise(protocol, this.promisedProposal, this.acceptedValue, suggestedValue, suggestionRanking, this.repNode.getElectionPriority(), this.repNode.getLogVersion(), JEVersion.CURRENT_VERSION);
    }

    TextProtocol.ResponseMessage process(Protocol.Accept accept) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(accept.getProposal()) != 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Accept: " + accept.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.acceptedValue = accept.getValue();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Accepted: " + accept.getProposal() + " Value: " + this.acceptedValue);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Accepted(protocol, accept.getProposal(), this.acceptedValue);
    }

    public static interface SuggestionGenerator {
        public Protocol.Value get(Proposer.Proposal var1);

        public long getRanking(Proposer.Proposal var1);
    }
}

