/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;

public class RepGroupDB {
    private final RepImpl repImpl;
    public final RepGroupImpl emptyGroup;
    private final Logger logger;
    public static final String GROUP_KEY = "$$GROUP_KEY$$";
    public static final DatabaseEntry groupKeyEntry = new DatabaseEntry();
    public static final long DB_ID = -257L;
    private static final int QUORUM_ACK_RETRIES = 5;
    private static final Durability QUORUM_ACK_DURABILITY;
    private static final TransactionConfig QUORUM_ACK;
    private static final TransactionConfig NO_ACK;
    static final TransactionConfig READ_ONLY;
    private static final Durability NO_ACK_DURABILITY;
    private static final Durability NO_ACK_NO_SYNC_DURABILITY;
    private static final TransactionConfig NO_ACK_NO_SYNC;

    public RepGroupDB(RepImpl repImpl) throws DatabaseException, IOException {
        this.repImpl = repImpl;
        DbConfigManager configManager = repImpl.getConfigManager();
        this.emptyGroup = new RepGroupImpl(configManager.get(RepParams.GROUP_NAME));
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepGroupImpl getGroup(RepImpl rImpl, String groupName, ReplicaConsistencyPolicy policy) throws DatabaseException {
        RepGroupImpl repGroupImpl;
        block4: {
            DatabaseImpl dbImpl = null;
            try {
                dbImpl = rImpl.getGroupDb(policy);
            }
            catch (DatabaseNotFoundException e) {
                return new RepGroupImpl(groupName, true);
            }
            TransactionConfig txnConfig = new TransactionConfig();
            txnConfig.setDurability(READ_ONLY.getDurability());
            txnConfig.setConsistencyPolicy(policy);
            txnConfig.setReadUncommitted(true);
            ReadonlyTxn txn = null;
            try {
                txn = new ReadonlyTxn(rImpl, txnConfig);
                RepGroupImpl group = RepGroupDB.fetchGroup(groupName, dbImpl, txn);
                group.makeConsistent();
                txn.commit();
                txn = null;
                repGroupImpl = group;
                Object var9_9 = null;
                if (txn == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var9_10 = null;
                    if (txn == null) break block5;
                    txn.abort();
                }
                throw throwable;
            }
            txn.abort();
        }
        return repGroupImpl;
    }

    public RepGroupImpl getGroup(ReplicaConsistencyPolicy policy) throws DatabaseException {
        return RepGroupDB.getGroup(this.repImpl, this.repImpl.getConfigManager().get(RepParams.GROUP_NAME), policy);
    }

    private static Cursor makeCursor(DatabaseImpl dbImpl, Txn txn, CursorConfig cursorConfig) {
        Cursor cursor = DbInternal.makeCursor(dbImpl, txn, cursorConfig);
        DbInternal.getCursorImpl(cursor).setAllowEviction(false);
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RepGroupImpl fetchGroup(String groupName, DatabaseImpl dbImpl, Txn txn) throws DatabaseException {
        RepGroupImpl repGroupImpl;
        block5: {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            NodeBinding miBinding = new NodeBinding();
            GroupBinding groupBinding = new GroupBinding();
            RepGroupImpl group = null;
            HashMap<Integer, RepNodeImpl> nodes = new HashMap<Integer, RepNodeImpl>();
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadCommitted(true);
            Cursor mcursor = null;
            try {
                mcursor = RepGroupDB.makeCursor(dbImpl, txn, cursorConfig);
                while (mcursor.getNext(keyEntry, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    String key = StringBinding.entryToString(keyEntry);
                    if (GROUP_KEY.equals(key)) {
                        group = (RepGroupImpl)groupBinding.entryToObject(value);
                        if (group.getName().equals(groupName)) continue;
                        throw EnvironmentFailureException.unexpectedState("The argument: " + groupName + " does not match the expected group name: " + group.getName());
                    }
                    RepNodeImpl mi = (RepNodeImpl)miBinding.entryToObject(value);
                    nodes.put(mi.getNameIdPair().getId(), mi);
                }
                if (group == null) {
                    throw EnvironmentFailureException.unexpectedState("Group key: $$GROUP_KEY$$ is missing");
                }
                group.setNodes(nodes);
                repGroupImpl = group;
                Object var14_13 = null;
                if (mcursor == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var14_14 = null;
                    if (mcursor == null) break block6;
                    mcursor.close();
                }
                throw throwable;
            }
            mcursor.close();
        }
        return repGroupImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirstNode() throws DatabaseException {
        MasterTxn txn;
        String nodeName;
        block6: {
            DbConfigManager configManager = this.repImpl.getConfigManager();
            String groupName = configManager.get(RepParams.GROUP_NAME);
            nodeName = configManager.get(RepParams.NODE_NAME);
            DatabaseImpl groupDbImpl = this.repImpl.createGroupDb();
            GroupBinding groupBinding = new GroupBinding();
            RepGroupImpl repGroup = new RepGroupImpl(groupName);
            DatabaseEntry groupEntry = new DatabaseEntry();
            groupBinding.objectToEntry(repGroup, groupEntry);
            TransactionConfig txnConfig = new TransactionConfig();
            txnConfig.setDurability(NO_ACK.getDurability());
            txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
            txn = null;
            Cursor cursor = null;
            try {
                txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, this.repImpl.getNameIdPair());
                cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
                OperationStatus status = cursor.put(groupKeyEntry, groupEntry);
                if (status != OperationStatus.SUCCESS) {
                    throw EnvironmentFailureException.unexpectedState("Couldn't write first group entry " + (Object)((Object)status));
                }
                cursor.close();
                cursor = null;
                txn.commit();
                txn = null;
                Object var13_12 = null;
                if (cursor == null) break block6;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (txn != null) {
                    txn.abort();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (txn != null) {
            txn.abort();
        }
        this.ensureMember(new RepNodeImpl(nodeName, this.repImpl.getHostName(), this.repImpl.getPort()));
    }

    public void ensureMember(Protocol.NodeGroupInfo membershipInfo) throws InsufficientReplicasException, InsufficientAcksException, DatabaseException {
        this.ensureMember(new RepNodeImpl(membershipInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void ensureMember(RepNodeImpl ensureNode) throws DatabaseException {
        Cursor cursor;
        ReadonlyTxn txn;
        block14: {
            block12: {
                block13: {
                    DatabaseImpl groupDbImpl;
                    try {
                        groupDbImpl = this.repImpl.getGroupDb();
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                    DatabaseEntry nodeNameKey = new DatabaseEntry();
                    StringBinding.stringToEntry(ensureNode.getName(), nodeNameKey);
                    DatabaseEntry value = new DatabaseEntry();
                    NodeBinding mib = new NodeBinding();
                    txn = null;
                    cursor = null;
                    try {
                        txn = new ReadonlyTxn(this.repImpl, NO_ACK);
                        CursorConfig config = new CursorConfig();
                        config.setReadCommitted(true);
                        cursor = RepGroupDB.makeCursor(groupDbImpl, txn, config);
                        OperationStatus status = cursor.getSearchKey(nodeNameKey, value, null);
                        if (status == OperationStatus.SUCCESS) {
                            RepNodeImpl miInDb = (RepNodeImpl)mib.entryToObject(value);
                            if (!miInDb.equivalent(ensureNode)) {
                                LoggerUtils.warning(this.logger, this.repImpl, "Incompatible node descriptions. Membership database definition: " + miInDb.toString() + " Transient definition: " + ensureNode.toString());
                                throw EnvironmentFailureException.unexpectedState("Incompatible node descriptions for node ID: " + ensureNode.getNodeId());
                            }
                            if (miInDb.isQuorumAck()) {
                                Object var12_12 = null;
                                if (cursor == null) break block12;
                                break block13;
                            }
                            ensureNode.getNameIdPair().update(miInDb.getNameIdPair());
                            LoggerUtils.info(this.logger, this.repImpl, "Present but not ack'd node: " + ensureNode.getNodeId() + " ack status: " + miInDb.isQuorumAck());
                        }
                        cursor.close();
                        cursor = null;
                        txn.commit();
                        txn = null;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (txn != null) {
                            txn.abort();
                        }
                        throw throwable;
                    }
                }
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
            return;
        }
        Object var12_13 = null;
        if (cursor != null) {
            cursor.close();
        }
        if (txn != null) {
            txn.abort();
        }
        this.createMember(ensureNode);
        this.refreshGroupAndNotifyGroupChange(ensureNode.getName(), GroupChangeEvent.GroupChangeType.ADD);
    }

    private void refreshGroupAndNotifyGroupChange(String nodeName, GroupChangeEvent.GroupChangeType opType) {
        this.repImpl.getRepNode().refreshCachedGroup();
        this.repImpl.getRepNode().getMonitorEventManager().notifyGroupChange(nodeName, opType);
    }

    public void removeMember(RepNodeImpl removeNode) {
        LoggerUtils.info(this.logger, this.repImpl, "Deleting node: " + removeNode.getName());
        TwoPhaseUpdate twoPhaseUpdate = new TwoPhaseUpdate(removeNode){

            void phase1Body() {
                RepGroupImpl repGroup = RepGroupDB.this.fetchGroupObject(this.txn, this.groupDbImpl);
                int changeVersion = repGroup.incrementChangeVersion();
                RepGroupDB.this.saveGroupObject(this.txn, repGroup, this.groupDbImpl);
                this.node.setChangeVersion(changeVersion);
                this.node.setRemoved(true);
                RepGroupDB.this.saveNodeObject(this.txn, this.node, this.groupDbImpl);
            }
        };
        twoPhaseUpdate.execute();
        this.refreshGroupAndNotifyGroupChange(removeNode.getName(), GroupChangeEvent.GroupChangeType.REMOVE);
        LoggerUtils.info(this.logger, this.repImpl, "Successfully deleted node: " + removeNode.getName());
    }

    private void createMember(RepNodeImpl node) throws InsufficientReplicasException, InsufficientAcksException, DatabaseException {
        LoggerUtils.fine(this.logger, this.repImpl, "Adding node: " + node.getNameIdPair());
        this.twoPhaseMemberUpdate(node);
        LoggerUtils.info(this.logger, this.repImpl, "Successfully added node:" + node.getNameIdPair() + " HostPort = " + node.getHostName() + ": " + node.getPort() + " [" + (Object)((Object)node.getType()) + "]");
    }

    public void updateMember(RepNodeImpl node) throws InsufficientReplicasException, InsufficientAcksException, DatabaseException {
        LoggerUtils.fine(this.logger, this.repImpl, "Updating node: " + node.getNameIdPair());
        this.twoPhaseMemberUpdate(node);
        this.repImpl.getRepNode().refreshCachedGroup();
        LoggerUtils.info(this.logger, this.repImpl, "Successfully updated node: " + node.getNameIdPair() + " Hostport = " + node.getHostName() + ": " + node.getPort() + " [" + (Object)((Object)node.getType()) + "]");
    }

    private void twoPhaseMemberUpdate(RepNodeImpl node) throws InsufficientReplicasException, InsufficientAcksException, DatabaseException {
        TwoPhaseUpdate twoPhaseUpdate = new TwoPhaseUpdate(node){

            void phase1Body() {
                RepGroupImpl repGroup = RepGroupDB.this.fetchGroupObject(this.txn, this.groupDbImpl);
                RepGroupDB.fetchGroup(repGroup.getName(), this.groupDbImpl, this.txn).checkForConflicts(this.node);
                int changeVersion = repGroup.incrementChangeVersion();
                if (this.node.getNameIdPair().hasNullId()) {
                    this.node.getNameIdPair().setId(repGroup.getNextNodeId());
                }
                RepGroupDB.this.saveGroupObject(this.txn, repGroup, this.groupDbImpl);
                this.node.setChangeVersion(changeVersion);
                RepGroupDB.this.saveNodeObject(this.txn, this.node, this.groupDbImpl);
            }

            void deadlockHandler() {
                this.node.getNameIdPair().revertToNull();
            }

            void insufficientReplicasHandler() {
                this.node.getNameIdPair().revertToNull();
            }
        };
        twoPhaseUpdate.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLocalCBVLSN(NameIdPair nameIdPair, VLSN newCBVLSN) throws DatabaseException {
        RepNode repNode22;
        boolean ok;
        MasterTxn txn;
        RepGroupImpl.BarrierState barrierState;
        block23: {
            RepNodeImpl node;
            OperationStatus status;
            Cursor cursor;
            NodeBinding mib;
            DatabaseEntry value;
            block21: {
                RepNode repNode22;
                boolean bl;
                block22: {
                    DatabaseImpl groupDbImpl = null;
                    try {
                        groupDbImpl = this.repImpl.probeGroupDb();
                    }
                    catch (DatabaseException e) {
                        return false;
                    }
                    if (groupDbImpl == null) {
                        return false;
                    }
                    DatabaseEntry nodeNameKey = new DatabaseEntry();
                    StringBinding.stringToEntry(nameIdPair.getName(), nodeNameKey);
                    value = new DatabaseEntry();
                    mib = new NodeBinding();
                    barrierState = new RepGroupImpl.BarrierState(newCBVLSN, System.currentTimeMillis());
                    txn = null;
                    cursor = null;
                    ok = false;
                    try {
                        txn = new MasterTxn((EnvironmentImpl)this.repImpl, NO_ACK_NO_SYNC, this.repImpl.getNameIdPair());
                        cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
                        status = cursor.getSearchKey(nodeNameKey, value, LockMode.RMW);
                        if (status != OperationStatus.SUCCESS) {
                            throw EnvironmentFailureException.unexpectedState("Node ID: " + nameIdPair + " not present in group db");
                        }
                        node = (RepNodeImpl)mib.entryToObject(value);
                        VLSN lastCBVLSN = node.getBarrierState().getLastCBVLSN();
                        if (!lastCBVLSN.equals(newCBVLSN)) break block21;
                        ok = true;
                        bl = true;
                        Object var16_16 = null;
                        if (cursor == null) break block22;
                    }
                    catch (Throwable throwable) {
                        RepNode repNode22;
                        Object var16_18 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (txn != null) {
                            if (ok) {
                                txn.commit(NO_ACK_NO_SYNC_DURABILITY);
                            } else {
                                txn.abort();
                            }
                            txn = null;
                        }
                        if (ok && (repNode22 = this.repImpl.getRepNode()) != null) {
                            repNode22.updateGroupInfo(nameIdPair, barrierState);
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (txn != null) {
                    if (ok) {
                        txn.commit(NO_ACK_NO_SYNC_DURABILITY);
                    } else {
                        txn.abort();
                    }
                    txn = null;
                }
                if (ok && (repNode22 = this.repImpl.getRepNode()) != null) {
                    repNode22.updateGroupInfo(nameIdPair, barrierState);
                }
                return bl;
            }
            node.setBarrierState(barrierState);
            mib.objectToEntry(node, value);
            status = cursor.putCurrent(value);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Node ID: " + nameIdPair + " stored localCBVLSN could not be updated. Status: " + (Object)((Object)status));
            }
            LoggerUtils.fine(this.logger, this.repImpl, "Local CBVLSN updated to " + newCBVLSN + " for node " + nameIdPair);
            ok = true;
            Object var16_17 = null;
            if (cursor == null) break block23;
            cursor.close();
        }
        if (txn != null) {
            if (ok) {
                txn.commit(NO_ACK_NO_SYNC_DURABILITY);
            } else {
                txn.abort();
            }
            txn = null;
        }
        if (ok && (repNode22 = this.repImpl.getRepNode()) != null) {
            repNode22.updateGroupInfo(nameIdPair, barrierState);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RepGroupImpl fetchGroupObject(Txn txn, DatabaseImpl groupDbImpl) throws DatabaseException {
        GroupBinding groupBinding = new GroupBinding();
        DatabaseEntry groupEntry = new DatabaseEntry();
        Cursor cursor = null;
        try {
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.getSearchKey(groupKeyEntry, groupEntry, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Group entry key: $$GROUP_KEY$$ missing from group database");
            }
            Object var8_7 = null;
            if (cursor == null) return (RepGroupImpl)groupBinding.entryToObject(groupEntry);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
        return (RepGroupImpl)groupBinding.entryToObject(groupEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveGroupObject(Txn txn, RepGroupImpl repGroup, DatabaseImpl groupDbImpl) throws DatabaseException {
        GroupBinding groupBinding = new GroupBinding();
        DatabaseEntry groupEntry = new DatabaseEntry();
        groupBinding.objectToEntry(repGroup, groupEntry);
        Cursor cursor = null;
        try {
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.put(groupKeyEntry, groupEntry);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Group entry save failed");
            }
            Object var9_8 = null;
            if (cursor == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveNodeObject(Txn txn, RepNodeImpl node, DatabaseImpl groupDbImpl) throws DatabaseException {
        DatabaseEntry nodeNameKey = new DatabaseEntry();
        StringBinding.stringToEntry(node.getName(), nodeNameKey);
        NodeBinding nodeBinding = new NodeBinding();
        DatabaseEntry memberInfoEntry = new DatabaseEntry();
        nodeBinding.objectToEntry(node, memberInfoEntry);
        Cursor cursor = null;
        try {
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.put(nodeNameKey, memberInfoEntry);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Group entry save failed");
            }
            Object var10_9 = null;
            if (cursor == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
    }

    public static RepGroupImpl getGroup(File envDir) {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(false);
        Environment env = new Environment(envDir, envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(false);
        Transaction txn = env.beginTransaction(null, null);
        Database db = env.openDatabase(txn, DbType.REP_GROUP.getInternalName(), dbConfig);
        DatabaseEntry groupEntry = new DatabaseEntry();
        OperationStatus status = db.get(txn, groupKeyEntry, groupEntry, LockMode.READ_COMMITTED);
        if (status != OperationStatus.SUCCESS) {
            throw new IllegalStateException("Group entry not found " + (Object)((Object)status));
        }
        GroupBinding groupBinding = new GroupBinding();
        RepGroupImpl group = (RepGroupImpl)groupBinding.entryToObject(groupEntry);
        group = RepGroupDB.fetchGroup(group.getName(), DbInternal.getDatabaseImpl(db), DbInternal.getTxn(txn));
        txn.commit();
        db.close();
        env.close();
        return group;
    }

    public void reinitFirstNode(VLSN lastOldVLSN) {
        DbConfigManager configManager = this.repImpl.getConfigManager();
        String groupName = configManager.get(RepParams.GROUP_NAME);
        String nodeName = configManager.get(RepParams.NODE_NAME);
        String hostPortPair = configManager.get(RepParams.NODE_HOST_PORT);
        String hostname = HostPortPair.getHostname(hostPortPair);
        int port = HostPortPair.getPort(hostPortPair);
        DatabaseImpl dbImpl = this.repImpl.getGroupDb();
        TransactionConfig txnConfig = new TransactionConfig();
        txnConfig.setDurability(NO_ACK.getDurability());
        txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        NameIdPair nameIdPair = this.repImpl.getRepNode().getNameIdPair();
        nameIdPair.revertToNull();
        MasterTxn txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, nameIdPair);
        RepGroupImpl prevRepGroup = this.fetchGroupObject(txn, dbImpl);
        txn.commit();
        int nodeIdSequenceStart = prevRepGroup.getNodeIdSequence();
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        int firstNodeId = nodeIdSequenceStart + 1;
        nameIdPair.setId(firstNodeId);
        RepNodeImpl firstNode = new RepNodeImpl(nodeName, hostname, port);
        RepGroupImpl.BarrierState barrierState = new RepGroupImpl.BarrierState(lastOldVLSN, System.currentTimeMillis());
        firstNode.setBarrierState(barrierState);
        txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, nameIdPair);
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadCommitted(true);
        Cursor mcursor = RepGroupDB.makeCursor(dbImpl, txn, cursorConfig);
        while (mcursor.getNext(keyEntry, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            String key = StringBinding.entryToString(keyEntry);
            if (GROUP_KEY.equals(key)) {
                GroupBinding groupBinding = new GroupBinding();
                RepGroupImpl repGroup = new RepGroupImpl(groupName);
                repGroup.setNodeIdSequence(nodeIdSequenceStart);
                DatabaseEntry groupEntry = new DatabaseEntry();
                groupBinding.objectToEntry(repGroup, groupEntry);
                OperationStatus status = mcursor.putCurrent(groupEntry);
                if (OperationStatus.SUCCESS.equals((Object)status)) continue;
                throw new IllegalStateException("Unexpected state:" + (Object)((Object)status));
            }
            LoggerUtils.info(this.logger, this.repImpl, "Removing node: " + key);
            mcursor.delete();
        }
        mcursor.close();
        txn.commit();
        this.ensureMember(firstNode);
        if (firstNodeId != firstNode.getNodeId()) {
            throw new IllegalStateException("Expected nodeid:" + firstNodeId + " but found:" + firstNode.getNodeId());
        }
    }

    static {
        StringBinding.stringToEntry(GROUP_KEY, groupKeyEntry);
        QUORUM_ACK_DURABILITY = new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY);
        QUORUM_ACK = new TransactionConfig();
        READ_ONLY = NO_ACK = new TransactionConfig();
        NO_ACK_DURABILITY = new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.NONE);
        NO_ACK_NO_SYNC_DURABILITY = new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE);
        NO_ACK_NO_SYNC = new TransactionConfig();
        QUORUM_ACK.setDurability(QUORUM_ACK_DURABILITY);
        NO_ACK.setDurability(NO_ACK_DURABILITY);
        NO_ACK_NO_SYNC.setDurability(NO_ACK_NO_SYNC_DURABILITY);
    }

    private abstract class TwoPhaseUpdate {
        final RepNodeImpl node;
        final DatabaseImpl groupDbImpl;
        protected Txn txn;
        private DatabaseException phase1Exception = null;

        private TwoPhaseUpdate(RepNodeImpl node) {
            this.node = node;
            try {
                this.groupDbImpl = RepGroupDB.this.repImpl.getGroupDb();
            }
            catch (DatabaseNotFoundException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
        }

        void insufficientReplicasHandler() {
        }

        void deadlockHandler() {
        }

        abstract void phase1Body();

        void phase2Body() {
            this.node.setQuorumAck(true);
            RepGroupDB.this.saveNodeObject(this.txn, this.node, this.groupDbImpl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void phase1() throws DatabaseException {
            int i = 0;
            while (true) {
                block15: {
                    Object var4_7;
                    if (i >= 5) {
                        LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 failed: " + this.phase1Exception.getMessage());
                        throw this.phase1Exception;
                    }
                    this.txn = null;
                    try {
                        try {
                            this.txn = new MasterTxn((EnvironmentImpl)RepGroupDB.this.repImpl, QUORUM_ACK, RepGroupDB.this.repImpl.getNameIdPair());
                            this.phase1Body();
                            this.txn.commit(QUORUM_ACK_DURABILITY);
                            this.txn = null;
                            var4_7 = null;
                            if (this.txn == null) return;
                        }
                        catch (InsufficientReplicasException e) {
                            this.phase1Exception = e;
                            this.insufficientReplicasHandler();
                            LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 retry; for node: " + this.node.getName() + " insufficient active replicas: " + e.getMessage());
                            var4_7 = null;
                            if (this.txn != null) {
                                this.txn.abort();
                            }
                            break block15;
                        }
                        catch (InsufficientAcksException e) {
                            this.phase1Exception = e;
                            LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 retry; for node: " + this.node.getName() + " insufficient acks: " + e.getMessage());
                            var4_7 = null;
                            if (this.txn != null) {
                                this.txn.abort();
                            }
                            break block15;
                        }
                        catch (LockConflictException e) {
                            this.phase1Exception = e;
                            this.deadlockHandler();
                            LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 retry; for node: " + this.node.getName() + " deadlock exception: " + e.getMessage());
                            var4_7 = null;
                            if (this.txn != null) {
                                this.txn.abort();
                            }
                            break block15;
                        }
                        catch (DatabaseException e) {
                            LoggerUtils.severe(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 failed unexpectedly: " + e.getMessage());
                            if (this.txn != null) {
                                this.txn.abort();
                            }
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        var4_7 = null;
                        if (this.txn != null) {
                            this.txn.abort();
                        }
                        throw throwable;
                    }
                    this.txn.abort();
                    return;
                }
                ++i;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void phase2() {
            try {
                try {
                    this.txn = new MasterTxn((EnvironmentImpl)RepGroupDB.this.repImpl, NO_ACK, RepGroupDB.this.repImpl.getNameIdPair());
                    this.phase2Body();
                    this.txn.commit();
                    this.txn = null;
                }
                catch (DatabaseException e) {
                    LoggerUtils.severe(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Unexpected failure in Phase 2: " + e.getMessage());
                    throw e;
                }
                Object var3_1 = null;
                if (this.txn == null) return;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (this.txn == null) throw throwable;
                this.txn.abort();
                throw throwable;
            }
            this.txn.abort();
        }

        void execute() {
            this.phase1();
            this.phase2();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeBinding
    extends TupleBinding<RepNodeImpl> {
        @Override
        public RepNodeImpl entryToObject(TupleInput input2) {
            RepNodeImpl mi = new RepNodeImpl(NameIdPair.deserialize(input2), NodeType.values()[input2.readByte()], input2.readBoolean(), input2.readBoolean(), input2.readString(), input2.readInt(), new RepGroupImpl.BarrierState(new VLSN(input2.readLong()), input2.readLong()), input2.readInt());
            return mi;
        }

        @Override
        public void objectToEntry(RepNodeImpl mi, TupleOutput output) {
            RepGroupImpl.BarrierState syncState = mi.getBarrierState();
            mi.getNameIdPair().serialize(output);
            output.writeByte(mi.getType().ordinal());
            output.writeBoolean(mi.isQuorumAck());
            output.writeBoolean(mi.isRemoved());
            output.writeString(mi.getHostName());
            output.writeInt(mi.getPort());
            output.writeLong(syncState.getLastCBVLSN().getSequence());
            output.writeLong(syncState.getBarrierTime());
            output.writeInt(mi.getChangeVersion());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GroupBinding
    extends TupleBinding<RepGroupImpl> {
        @Override
        public RepGroupImpl entryToObject(TupleInput input2) {
            return new RepGroupImpl(input2.readString(), new UUID(input2.readLong(), input2.readLong()), input2.readInt(), input2.readInt(), input2.readInt(), null);
        }

        @Override
        public void objectToEntry(RepGroupImpl group, TupleOutput output) {
            output.writeString(group.getName());
            output.writeLong(group.getUUID().getMostSignificantBits());
            output.writeLong(group.getUUID().getLeastSignificantBits());
            output.writeInt(group.getVersion());
            output.writeInt(group.getChangeVersion());
            output.writeInt(group.getNodeIdSequence());
        }
    }
}

