/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.sf.picard.sam.HitsForInsert;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;

public class BestEndMapqPrimaryAlignmentStrategy
implements PrimaryAlignmentSelectionStrategy {
    private static final MapqComparator MAPQ_COMPARATOR = new MapqComparator();
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        if (hitsForInsert.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        Collections.sort(hitsForInsert.firstOfPairOrFragment, MAPQ_COMPARATOR);
        Collections.sort(hitsForInsert.secondOfPair, MAPQ_COMPARATOR);
        this.randomlySelectPrimaryFromBest(hitsForInsert.firstOfPairOrFragment);
        this.randomlySelectPrimaryFromBest(hitsForInsert.secondOfPair);
        hitsForInsert.setPrimaryAlignment(0);
        if (!hitsForInsert.isPaired()) {
            return;
        }
        if (hitsForInsert.firstOfPairOrFragment.size() <= 1 || hitsForInsert.secondOfPair.size() <= 1) {
            return;
        }
        int n = hitsForInsert.firstOfPairOrFragment.size() - 1;
        for (int i = 0; i < n; ++i) {
            hitsForInsert.secondOfPair.add(1, null);
        }
    }

    private void randomlySelectPrimaryFromBest(List<SAMRecord> list) {
        int n;
        if (list.isEmpty()) {
            return;
        }
        int n2 = list.get(0).getMappingQuality();
        for (n = 1; n < list.size() && list.get(n).getMappingQuality() == n2; ++n) {
        }
        int n3 = this.random.nextInt(n);
        if (n3 == 0) {
            return;
        }
        SAMRecord sAMRecord = list.get(0);
        list.set(0, list.get(n3));
        list.set(n3, sAMRecord);
    }

    private static class MapqComparator
    implements Comparator<SAMRecord> {
        private MapqComparator() {
        }

        @Override
        public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            if (sAMRecord.getReadUnmappedFlag()) {
                if (sAMRecord2.getReadUnmappedFlag()) {
                    return 0;
                }
                return 1;
            }
            if (sAMRecord2.getReadUnmappedFlag()) {
                return -1;
            }
            return -SAMUtils.compareMapqs(sAMRecord.getMappingQuality(), sAMRecord2.getMappingQuality());
        }
    }
}

