/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;

public class ReorderSam
extends CommandLineProgram {
    @Usage(programVersion="1.0")
    public String USAGE = "Not to be confused with SortSam which sorts a SAM or BAM file with a valid sequence dictionary, ReorderSam reorders reads in a SAM/BAM file to match the contig ordering in a provided reference file, as determined by exact name matching of contigs.  Reads mapped to contigs absent in the new reference are dropped. Runs substantially faster if the input is an indexed BAM file.";
    @Option(shortName="I", doc="Input file (bam or sam) to extract reads from.")
    public File INPUT;
    @Option(shortName="O", doc="Output file (bam or sam) to write extracted reads to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Reference sequence to reorder reads to match.  A sequence dictionary corresponding to the reference fasta is required.  Create one with CreateSequenceDictionary.jar.")
    public File REFERENCE;
    @Option(shortName="S", doc="If true, then allows only a partial overlap of the BAM contigs with the new reference sequence contigs.  By default, this tool requires a corresponding contig in the new reference for each read contig")
    public boolean ALLOW_INCOMPLETE_DICT_CONCORDANCE = false;
    @Option(shortName="U", doc="If true, then permits mapping from a read contig to a new reference contig with the same name but a different length.  Highly dangerous, only use if you know what you are doing.")
    public boolean ALLOW_CONTIG_LENGTH_DISCORDANCE = false;
    private final Log log = Log.getInstance(ReorderSam.class);

    public static void main(String[] stringArray) {
        new ReorderSam().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsReadable(this.REFERENCE);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE);
        SAMSequenceDictionary sAMSequenceDictionary = referenceSequenceFile.getSequenceDictionary();
        if (sAMSequenceDictionary == null) {
            this.log.error("No reference sequence dictionary found. Aborting.  You can create a sequence dictionary for the reference fasta using CreateSequenceDictionary.jar.");
            sAMFileReader.close();
            return 1;
        }
        this.printDictionary("SAM/BAM file", sAMFileReader.getFileHeader().getSequenceDictionary());
        this.printDictionary("Reference", sAMSequenceDictionary);
        Map<Integer, Integer> map2 = this.buildSequenceDictionaryMap(sAMSequenceDictionary, sAMFileReader.getFileHeader().getSequenceDictionary());
        SAMFileHeader sAMFileHeader = sAMFileReader.getFileHeader().clone();
        sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
        this.log.info("Writing reads...");
        if (sAMFileReader.hasIndex()) {
            SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, true, this.OUTPUT);
            for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
                SAMRecordIterator sAMRecordIterator = sAMFileReader.query(sAMSequenceRecord.getSequenceName(), 0, 0, false);
                this.writeReads(sAMFileWriter, sAMRecordIterator, map2, sAMSequenceRecord.getSequenceName());
            }
            this.writeReads(sAMFileWriter, sAMFileReader.queryUnmapped(), map2, "unmapped");
            sAMFileWriter.close();
        } else {
            SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, false, this.OUTPUT);
            this.writeReads(sAMFileWriter, sAMFileReader.iterator(), map2, "All reads");
            sAMFileWriter.close();
        }
        sAMFileReader.close();
        return 0;
    }

    private int newOrderIndex(SAMRecord sAMRecord, int n, Map<Integer, Integer> map2) {
        if (n == -1) {
            return -1;
        }
        Integer n2 = map2.get(n);
        if (n2 == null) {
            throw new PicardException("BUG: no mapping found for read " + sAMRecord.format());
        }
        return n2;
    }

    private void writeReads(SAMFileWriter sAMFileWriter, SAMRecordIterator sAMRecordIterator, Map<Integer, Integer> map2, String string2) {
        long l = 0L;
        this.log.info("  Processing " + string2);
        while (sAMRecordIterator.hasNext()) {
            ++l;
            SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
            int n = sAMRecord.getReferenceIndex();
            int n2 = sAMRecord.getMateReferenceIndex();
            int n3 = this.newOrderIndex(sAMRecord, n, map2);
            sAMRecord.setHeader(sAMFileWriter.getFileHeader());
            sAMRecord.setReferenceIndex(n3);
            int n4 = this.newOrderIndex(sAMRecord, n2, map2);
            if (n2 != -1 && n4 == -1) {
                sAMRecord.setMateAlignmentStart(0);
                sAMRecord.setMateUnmappedFlag(true);
            }
            sAMRecord.setMateReferenceIndex(n4);
            sAMFileWriter.addAlignment(sAMRecord);
        }
        sAMRecordIterator.close();
        this.log.info("Wrote " + l + " reads");
    }

    private Map<Integer, Integer> buildSequenceDictionaryMap(SAMSequenceDictionary sAMSequenceDictionary, SAMSequenceDictionary sAMSequenceDictionary2) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        this.log.info("Reordering SAM/BAM file:");
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            SAMSequenceRecord sAMSequenceRecord2 = sAMSequenceDictionary2.getSequence(sAMSequenceRecord.getSequenceName());
            if (sAMSequenceRecord2 == null) continue;
            if (sAMSequenceRecord.getSequenceLength() != sAMSequenceRecord2.getSequenceLength()) {
                String string2 = String.format("Discordant contig lengths: read %s LN=%d, ref %s LN=%d", sAMSequenceRecord2.getSequenceName(), sAMSequenceRecord2.getSequenceLength(), sAMSequenceRecord.getSequenceName(), sAMSequenceRecord.getSequenceLength());
                if (this.ALLOW_CONTIG_LENGTH_DISCORDANCE) {
                    this.log.warn(string2);
                } else {
                    throw new PicardException(string2);
                }
            }
            this.log.info(String.format("  Reordering read contig %s [index=%d] to => ref contig %s [index=%d]%n", sAMSequenceRecord2.getSequenceName(), sAMSequenceRecord2.getSequenceIndex(), sAMSequenceRecord.getSequenceName(), sAMSequenceRecord.getSequenceIndex()));
            hashMap.put(sAMSequenceRecord2.getSequenceIndex(), sAMSequenceRecord.getSequenceIndex());
        }
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary2.getSequences()) {
            if (hashMap.containsKey(sAMSequenceRecord.getSequenceIndex())) continue;
            if (this.ALLOW_INCOMPLETE_DICT_CONCORDANCE) {
                hashMap.put(sAMSequenceRecord.getSequenceIndex(), -1);
                continue;
            }
            throw new PicardException("New reference sequence does not contain a matching contig for " + sAMSequenceRecord.getSequenceName());
        }
        return hashMap;
    }

    private void printDictionary(String string2, SAMSequenceDictionary sAMSequenceDictionary) {
        this.log.info(string2);
        for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary.getSequences()) {
            this.log.info("  SN=%s LN=%d%n", sAMSequenceRecord.getSequenceName(), sAMSequenceRecord.getSequenceLength());
        }
    }
}

