/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;

class Chunk
implements Cloneable,
Serializable,
Comparable<Chunk> {
    private static final long serialVersionUID = 1L;
    private long mChunkStart;
    private long mChunkEnd;

    public Chunk(long l, long l2) {
        this.mChunkStart = l;
        this.mChunkEnd = l2;
    }

    public Chunk clone() {
        return new Chunk(this.mChunkStart, this.mChunkEnd);
    }

    protected long getChunkStart() {
        return this.mChunkStart;
    }

    protected void setChunkStart(long l) {
        this.mChunkStart = l;
    }

    protected long getChunkEnd() {
        return this.mChunkEnd;
    }

    protected void setChunkEnd(long l) {
        this.mChunkEnd = l;
    }

    @Override
    public int compareTo(Chunk chunk) {
        int n = Long.signum(this.mChunkStart - chunk.mChunkStart);
        if (n == 0) {
            n = Long.signum(this.mChunkEnd - chunk.mChunkEnd);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Chunk chunk = (Chunk)object;
        if (this.mChunkEnd != chunk.mChunkEnd) {
            return false;
        }
        return this.mChunkStart == chunk.mChunkStart;
    }

    public boolean overlaps(Chunk chunk) {
        long l;
        int n = this.compareTo(chunk);
        if (n == 0) {
            return true;
        }
        Chunk chunk2 = n == -1 ? this : chunk;
        Chunk chunk3 = n == 1 ? this : chunk;
        long l2 = BlockCompressedFilePointerUtil.getBlockAddress(chunk2.getChunkEnd());
        if (l2 > (l = BlockCompressedFilePointerUtil.getBlockAddress(chunk3.getChunkStart()))) {
            return true;
        }
        if (l2 == l) {
            int n2;
            int n3 = BlockCompressedFilePointerUtil.getBlockOffset(chunk2.getChunkEnd());
            return n3 > (n2 = BlockCompressedFilePointerUtil.getBlockOffset(chunk3.getChunkStart()));
        }
        return false;
    }

    public boolean isAdjacentTo(Chunk chunk) {
        return BlockCompressedFilePointerUtil.getBlockAddress(this.getChunkEnd()) == BlockCompressedFilePointerUtil.getBlockAddress(chunk.getChunkStart()) && BlockCompressedFilePointerUtil.getBlockOffset(this.getChunkEnd()) == BlockCompressedFilePointerUtil.getBlockOffset(chunk.getChunkStart()) || BlockCompressedFilePointerUtil.getBlockAddress(this.getChunkStart()) == BlockCompressedFilePointerUtil.getBlockAddress(chunk.getChunkEnd()) && BlockCompressedFilePointerUtil.getBlockOffset(this.getChunkStart()) == BlockCompressedFilePointerUtil.getBlockOffset(chunk.getChunkEnd());
    }

    public int hashCode() {
        int n = (int)(this.mChunkStart ^ this.mChunkStart >>> 32);
        n = 31 * n + (int)(this.mChunkEnd ^ this.mChunkEnd >>> 32);
        return n;
    }

    public String toString() {
        return String.format("%d:%d-%d:%d", this.mChunkStart >> 16, this.mChunkStart & 0xFFFFL, this.mChunkEnd >> 16, this.mChunkEnd & 0xFFFFL);
    }
}

