/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;

class ReadsFileInfo {
    private static final Pattern FILENAME_SPLIT = Pattern.compile("\\.");
    private final ReadsFileType readsFileType;
    private final boolean isGzFile;

    public static ReadsFileInfo forName(String string2) {
        return new ReadsFileInfo(string2);
    }

    ReadsFileInfo(String string2) {
        String string3;
        Validate.notNull(string2, "File name may not be null", new Object[0]);
        String[] stringArray = FILENAME_SPLIT.split(string2);
        if (stringArray.length < 2) {
            throw new ReadsFileParserException("Unable to determine file type for reads file " + string2);
        }
        this.isGzFile = stringArray[stringArray.length - 1].equalsIgnoreCase("gz");
        if (this.isGzFile) {
            if (stringArray.length < 3) {
                throw new ReadsFileParserException("Unable to determine file type for reads file " + string2);
            }
            string3 = stringArray[stringArray.length - 2].toLowerCase();
        } else {
            string3 = stringArray[stringArray.length - 1].toLowerCase();
        }
        switch (string3) {
            case "txt": 
            case "fastq": {
                this.readsFileType = ReadsFileType.FASTQ;
                break;
            }
            case "bam": {
                this.readsFileType = ReadsFileType.BAM;
                break;
            }
            case "sam": {
                this.readsFileType = ReadsFileType.SAM;
                break;
            }
            case "raw": {
                this.readsFileType = ReadsFileType.RAW;
                break;
            }
            default: {
                throw new ReadsFileParserException("Unsupported reads file type " + string3);
            }
        }
    }

    public ReadsFileType getReadsFileType() {
        return this.readsFileType;
    }

    public boolean isGzFile() {
        return this.isGzFile;
    }
}

