/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broadinstitute.rnai.poolq.impl.fileparser.ColumnFileParser;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReferenceFileParserException;

public class ReferenceFileParser {
    private static final Pattern NONEMPTY_DNA_RE = Pattern.compile("^[ACGT]+$");

    public Map<String, List<String>> parseMapFromStream(InputStream inputStream) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        int n = 0;
        int n2 = -1;
        for (String[] stringArray : new ColumnFileParser(inputStream)) {
            if (n < 1) {
                n2 = stringArray.length;
            }
            ++n;
            if (stringArray.length == 0) continue;
            if (stringArray.length != n2) {
                throw new ReferenceFileParserException.IncorrectNumberOfColumnsException("Line does not contain the correct number of columns", n, stringArray);
            }
            if (stringArray.length < 2) {
                throw new ReferenceFileParserException.IncorrectNumberOfColumnsException("Line does not contain at least two columns", n, stringArray);
            }
            String string2 = stringArray[0].trim();
            this.checkConstructIsValid(string2, n, stringArray);
            String string3 = stringArray[1].trim();
            this.checkConstructIdIsValid(string3, string2, hashMap, n, stringArray);
            ArrayList<String> arrayList = (ArrayList<String>)linkedHashMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                linkedHashMap.put(string2, arrayList);
            }
            arrayList.add(string3);
        }
        if (linkedHashMap.isEmpty()) {
            throw new ReferenceFileParserException.EmptyReferenceFileException("Reference file is empty", n);
        }
        return linkedHashMap;
    }

    private void checkConstructIsValid(String string2, int n, String[] stringArray) {
        if (!this.constructIsNonEmptyDnaSeq(string2)) {
            throw new ReferenceFileParserException.BadConstructException("Construct '" + string2 + "' is not a valid DNA sequence", n, stringArray);
        }
    }

    private boolean constructIsNonEmptyDnaSeq(String string2) {
        return NONEMPTY_DNA_RE.matcher(string2).matches();
    }

    private void checkConstructIdIsValid(String string2, String string3, Map<String, String> map2, int n, String[] stringArray) {
        if (string2 == null || string2.isEmpty()) {
            throw new ReferenceFileParserException.BadConstructIdException("Construct " + string3 + " is mapped to an invalid ID", n, stringArray);
        }
        String string4 = map2.get(string2);
        if (map2.containsKey(string2) && !string4.equals(string3)) {
            throw new ReferenceFileParserException.DuplicateConstructIdMappingException("Construct " + string2 + " is already mapped to ID " + string4, n, stringArray);
        }
        map2.put(string2, string3);
    }
}

