/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Requires;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.bcf2.BCF2Codec;
import org.broadinstitute.variant.bcf2.BCF2Decoder;
import org.broadinstitute.variant.bcf2.BCF2GenotypeFieldDecoders;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;

public class BCF2LazyGenotypesDecoder
implements LazyGenotypesContext.LazyParser {
    private final BCF2Codec codec;
    private final List<Allele> siteAlleles;
    private final int nSamples;
    private final int nFields;
    private final GenotypeBuilder[] builders;

    @Requires(value={"codec.getHeader().getNGenotypeSamples() == builders.length"})
    BCF2LazyGenotypesDecoder(BCF2Codec bCF2Codec, List<Allele> list, int n, int n2, GenotypeBuilder[] genotypeBuilderArray) {
        this.codec = bCF2Codec;
        this.siteAlleles = list;
        this.nSamples = n;
        this.nFields = n2;
        this.builders = genotypeBuilderArray;
    }

    @Override
    public LazyGenotypesContext.LazyData parse(Object object) {
        try {
            int n;
            BCF2Decoder bCF2Decoder = new BCF2Decoder(((BCF2Codec.LazyData)object).bytes);
            for (n = 0; n < this.nSamples; ++n) {
                this.builders[n].reset(true);
            }
            for (n = 0; n < this.nFields; ++n) {
                int n2 = (Integer)bCF2Decoder.decodeTypedValue();
                String string2 = this.codec.getDictionaryString(n2);
                byte by2 = bCF2Decoder.readTypeDescriptor();
                int n3 = bCF2Decoder.decodeNumberOfElements(by2);
                BCF2GenotypeFieldDecoders.Decoder decoder = this.codec.getGenotypeFieldDecoder(string2);
                try {
                    decoder.decode(this.siteAlleles, string2, bCF2Decoder, by2, n3, this.builders);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new TribbleException("BUG: expected encoding of field " + string2 + " inconsistent with the value observed in the decoded value");
                }
            }
            ArrayList<Genotype> arrayList = new ArrayList<Genotype>(this.nSamples);
            for (GenotypeBuilder genotypeBuilder : this.builders) {
                arrayList.add(genotypeBuilder.make());
            }
            return new LazyGenotypesContext.LazyData(arrayList, this.codec.getHeader().getSampleNamesInOrder(), this.codec.getHeader().getSampleNameToOffset());
        }
        catch (IOException iOException) {
            throw new TribbleException("Unexpected IOException parsing already read genotypes data block", iOException);
        }
    }
}

