/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Sequence;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;

public class PersistKeyAssigner {
    private volatile Catalog catalog;
    private volatile Format keyFieldFormat;
    private volatile Format entityFormat;
    private final boolean rawAccess;
    private final Sequence sequence;

    PersistKeyAssigner(PersistKeyBinding keyBinding, PersistEntityBinding entityBinding, Sequence sequence2) {
        this.catalog = keyBinding.catalog;
        this.keyFieldFormat = keyBinding.keyFormat.getSequenceKeyFormat();
        this.entityFormat = entityBinding.entityFormat;
        this.rawAccess = entityBinding.rawAccess;
        this.sequence = sequence2;
    }

    public boolean assignPrimaryKey(Object entity, DatabaseEntry key) throws DatabaseException {
        try {
            return this.assignPrimaryKeyInternal(entity, key);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                return this.assignPrimaryKeyInternal(entity, key);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private boolean assignPrimaryKeyInternal(Object entity, DatabaseEntry key) throws DatabaseException, RefreshException {
        if (this.entityFormat.isPriKeyNullOrZero(entity, this.rawAccess)) {
            Long value = this.sequence.get(null, 1);
            RecordOutput output = new RecordOutput(this.catalog, this.rawAccess);
            this.keyFieldFormat.writeObject(value, output, this.rawAccess);
            TupleBase.outputToEntry(output, key);
            RecordInput input2 = new RecordInput(this.catalog, this.rawAccess, null, 0, key.getData(), key.getOffset(), key.getSize());
            this.entityFormat.getReader().readPriKey(entity, input2, this.rawAccess);
            return true;
        }
        return false;
    }

    void refresh(PersistCatalog newCatalog) {
        this.catalog = newCatalog;
        this.entityFormat = this.catalog.getFormat(this.entityFormat.getClassName());
        this.keyFieldFormat = this.catalog.getFormat(this.keyFieldFormat.getClassName());
    }
}

