/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public class QualityScoreDistribution
extends SinglePassSamProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Program to chart " + "quality score distributions in a SAM or BAM file.";
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    @Option(doc="If set to true, include quality for no-call bases in the distribution.")
    public boolean INCLUDE_NO_CALLS = false;
    private final long[] qCounts = new long[128];
    private final long[] oqCounts = new long[128];
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(QualityScoreDistribution.class);

    public static void main(String[] stringArray) {
        System.exit(new QualityScoreDistribution().instanceMain(stringArray));
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        if (list.size() == 1) {
            this.plotSubtitle = list.get(0).getLibrary();
            if (null == this.plotSubtitle) {
                this.plotSubtitle = "";
            }
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        if (this.PF_READS_ONLY && sAMRecord.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && sAMRecord.getReadUnmappedFlag()) {
            return;
        }
        if (sAMRecord.isSecondaryOrSupplementary()) {
            return;
        }
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        byte[] byArray3 = sAMRecord.getOriginalBaseQualities();
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (!this.INCLUDE_NO_CALLS && SequenceUtil.isNoCall(byArray[i])) continue;
            byte by2 = byArray2[i];
            this.qCounts[by2] = this.qCounts[by2] + 1L;
            if (byArray3 == null) continue;
            byte by3 = byArray3[i];
            this.oqCounts[by3] = this.oqCounts[by3] + 1L;
        }
    }

    @Override
    protected void finish() {
        Histogram<Byte> histogram = new Histogram<Byte>("QUALITY", "COUNT_OF_Q");
        Histogram<Byte> histogram2 = new Histogram<Byte>("QUALITY", "COUNT_OF_OQ");
        for (int i = 0; i < this.qCounts.length; ++i) {
            if (this.qCounts[i] > 0L) {
                histogram.increment((byte)i, this.qCounts[i]);
            }
            if (this.oqCounts[i] <= 0L) continue;
            histogram2.increment((byte)i, this.oqCounts[i]);
        }
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.addHistogram(histogram);
        if (!histogram2.isEmpty()) {
            metricsFile.addHistogram(histogram2);
        }
        metricsFile.write(this.OUTPUT);
        if (histogram.isEmpty() && histogram2.isEmpty()) {
            this.log.warn("No valid bases found in input file. No plot will be produced.");
        } else {
            int n = RExecutor.executeFromClasspath("net/sf/picard/analysis/qualityScoreDistribution.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (n != 0) {
                throw new PicardException("R script qualityScoreDistribution.R failed with return code " + n);
            }
        }
    }
}

