/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;

abstract class BinaryFileIterator<TYPE>
implements Iterator<TYPE>,
Iterable<TYPE> {
    protected final File file;
    protected final long fileSize;
    protected final int elementSize;
    private final byte[] header;

    public BinaryFileIterator(byte[] byArray, File file, int n) {
        this.header = byArray;
        this.file = file;
        this.fileSize = file.length();
        this.elementSize = n;
    }

    public ByteBuffer getHeaderBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.header.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(this.header);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public void assertTotalElementsEqual(long l) {
        if (this.getElementsInFile() != l) {
            throw new PicardException("Expected " + l + " elements in file but found " + this.getElementsInFile() + " elements! File(" + this.file.getAbsolutePath() + ")");
        }
        if (this.getExtraBytes() != 0L) {
            throw new PicardException("Malformed file, expected " + ((long)this.header.length + l * (long)this.elementSize) + " bytes in file, found " + this.fileSize + " bytes for file(" + this.file.getAbsolutePath() + ")");
        }
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public long getExtraBytes() {
        return this.fileSize - (long)this.header.length - this.getElementsInFile() * (long)this.elementSize;
    }

    public long getElementsInFile() {
        return (this.fileSize - (long)this.header.length) / (long)this.elementSize;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public TYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<TYPE> iterator() {
        return this;
    }

    protected abstract TYPE getElement();

    public abstract void skipElements(int var1);

    @Override
    public abstract boolean hasNext();
}

