/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.Arrays;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.Iso8601Date;

public class AddOrReplaceReadGroups
extends CommandLineProgram {
    @Usage(programVersion="1.0")
    public String USAGE = "Replaces all read groups in the INPUT file with a new read group and assigns all reads to this read group in the OUTPUT BAM";
    @Option(shortName="I", doc="Input file (bam or sam).")
    public File INPUT = null;
    @Option(shortName="O", doc="Output file (bam or sam).")
    public File OUTPUT = null;
    @Option(shortName="SO", optional=true, doc="Optional sort order to output in. If not supplied OUTPUT is in the same order as INPUT.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(shortName="ID", doc="Read Group ID")
    public String RGID = "1";
    @Option(shortName="LB", doc="Read Group Library")
    public String RGLB;
    @Option(shortName="PL", doc="Read Group platform (e.g. illumina, solid)")
    public String RGPL;
    @Option(shortName="PU", doc="Read Group platform unit (eg. run barcode)")
    public String RGPU;
    @Option(shortName="SM", doc="Read Group sample name")
    public String RGSM;
    @Option(shortName="CN", doc="Read Group sequencing center name", optional=true)
    public String RGCN;
    @Option(shortName="DS", doc="Read Group description", optional=true)
    public String RGDS;
    @Option(shortName="DT", doc="Read Group run date", optional=true)
    public Iso8601Date RGDT;
    @Option(shortName="PI", doc="Read Group predicted insert size", optional=true)
    public Integer RGPI;
    private final Log log = Log.getInstance(AddOrReplaceReadGroups.class);

    public static void main(String[] stringArray) {
        new AddOrReplaceReadGroups().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(this.RGID);
        sAMReadGroupRecord.setLibrary(this.RGLB);
        sAMReadGroupRecord.setPlatform(this.RGPL);
        sAMReadGroupRecord.setSample(this.RGSM);
        sAMReadGroupRecord.setPlatformUnit(this.RGPU);
        if (this.RGCN != null) {
            sAMReadGroupRecord.setSequencingCenter(this.RGCN);
        }
        if (this.RGDS != null) {
            sAMReadGroupRecord.setDescription(this.RGDS);
        }
        if (this.RGDT != null) {
            sAMReadGroupRecord.setRunDate(this.RGDT);
        }
        if (this.RGPI != null) {
            sAMReadGroupRecord.setPredictedMedianInsertSize(this.RGPI);
        }
        this.log.info(String.format("Created read group ID=%s PL=%s LB=%s SM=%s%n", sAMReadGroupRecord.getId(), sAMReadGroupRecord.getPlatform(), sAMReadGroupRecord.getLibrary(), sAMReadGroupRecord.getSample()));
        SAMFileHeader sAMFileHeader = sAMFileReader.getFileHeader();
        SAMFileHeader sAMFileHeader2 = sAMFileHeader.clone();
        sAMFileHeader2.setReadGroups(Arrays.asList(sAMReadGroupRecord));
        if (this.SORT_ORDER != null) {
            sAMFileHeader2.setSortOrder(this.SORT_ORDER);
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, sAMFileHeader2.getSortOrder() == sAMFileHeader.getSortOrder(), this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(this.log);
        for (SAMRecord sAMRecord : sAMFileReader) {
            sAMRecord.setAttribute(SAMTag.RG.name(), (Object)this.RGID);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        sAMFileReader.close();
        sAMFileWriter.close();
        return 0;
    }
}

