/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.sam.BestEndMapqPrimaryAlignmentStrategy;
import net.sf.picard.sam.BestMapqPrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.EarliestFragmentPrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.MostDistantPrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.SamAlignmentMerger;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMProgramRecord;

public class MergeBamAlignment
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Merges alignment data from a SAM or BAM " + "file with additional data stored in an unmapped BAM file and produces a third SAM " + "or BAM file of aligned and unaligned reads. NOTE that this program expects to " + "find a sequence dictionary in the same directory as REFERENCE_SEQUENCE and expects it " + "to have the same base name as the reference fasta except with the extension '.dict'";
    @Option(shortName="UNMAPPED", doc="Original SAM or BAM file of unmapped reads, which must be in queryname order.")
    public File UNMAPPED_BAM;
    @Option(shortName="ALIGNED", doc="SAM or BAM file(s) with alignment data.", mutex={"READ1_ALIGNED_BAM", "READ2_ALIGNED_BAM"}, optional=true)
    public List<File> ALIGNED_BAM;
    @Option(shortName="R1_ALIGNED", doc="SAM or BAM file(s) with alignment data from the first read of a pair.", mutex={"ALIGNED_BAM"}, optional=true)
    public List<File> READ1_ALIGNED_BAM;
    @Option(shortName="R2_ALIGNED", doc="SAM or BAM file(s) with alignment data from the second read of a pair.", mutex={"ALIGNED_BAM"}, optional=true)
    public List<File> READ2_ALIGNED_BAM;
    @Option(shortName="O", doc="Merged SAM or BAM file to write to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Path to the fasta file for the reference sequence.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="PG", doc="The program group ID of the aligner (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_RECORD_ID;
    @Option(shortName="PG_VERSION", doc="The version of the program group (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_GROUP_VERSION;
    @Option(shortName="PG_COMMAND", doc="The command line of the program group (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_GROUP_COMMAND_LINE;
    @Option(shortName="PG_NAME", doc="The name of the program group (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_GROUP_NAME;
    @Option(doc="Whether this is a paired-end run.", shortName="PE")
    public Boolean PAIRED_RUN;
    @Option(doc="The expected jump size (required if this is a jumping library). Deprecated. Use EXPECTED_ORIENTATIONS instead", shortName="JUMP", mutex={"EXPECTED_ORIENTATIONS"}, optional=true)
    public Integer JUMP_SIZE;
    @Option(doc="Whether to clip adapters where identified.")
    public boolean CLIP_ADAPTERS = true;
    @Option(doc="Whether the lane is bisulfite sequence (used when caculating the NM tag).")
    public boolean IS_BISULFITE_SEQUENCE = false;
    @Option(doc="Whether to output only aligned reads.  ")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="The maximum number of insertions or deletions permitted for an alignment to be included. Alignments with more than this many insertions or deletions will be ignored. Set to -1 to allow any number of insertions or deletions.", shortName="MAX_GAPS")
    public int MAX_INSERTIONS_OR_DELETIONS = 1;
    @Option(doc="Reserved alignment attributes (tags starting with X, Y, or Z) that should be brought over from the alignment data when merging.")
    public List<String> ATTRIBUTES_TO_RETAIN = new ArrayList<String>();
    @Option(shortName="R1_TRIM", doc="The number of bases trimmed from the beginning of read 1 prior to alignment")
    public int READ1_TRIM = 0;
    @Option(shortName="R2_TRIM", doc="The number of bases trimmed from the beginning of read 2 prior to alignment")
    public int READ2_TRIM = 0;
    @Option(shortName="ORIENTATIONS", doc="The expected orientation of proper read pairs. Replaces JUMP_SIZE", mutex={"JUMP_SIZE"}, optional=true)
    public List<SamPairUtil.PairOrientation> EXPECTED_ORIENTATIONS;
    @Option(doc="Use the aligner's idea of what a proper pair is rather than computing in this program.")
    public boolean ALIGNER_PROPER_PAIR_FLAGS = false;
    @Option(shortName="SO", doc="The order in which the merged reads should be output.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.coordinate;
    @Option(doc="Strategy for selecting primary alignment when the aligner has provided more than one alignment for a pair or fragment, and none are marked as primary, more than one is marked as primary, or the primary alignment is filtered out for some reason. BestMapq expects that multiple alignments will be correlated with HI tag, and prefers the pair of alignments with the largest MAPQ, in the absence of a primary selected by the aligner. EarliestFragment prefers the alignment which maps the earliest base in the read. Note that EarliestFragment may not be used for paired reads. BestEndMapq is appropriate for cases in which the aligner is not pair-aware, and does not output the HI tag. It simply picks the alignment for each end with the highest MAPQ, and makes those alignments primary, regardless of whether the two alignments make sense together.MostDistant is also for a non-pair-aware aligner, and picks the alignment pair with the largest insert size. If all alignments would be chimeric, it picks the alignments for each end with the best MAPQ.  For all algorithms, ties are resolved arbitrarily.")
    public PrimaryAlignmentStrategy PRIMARY_ALIGNMENT_STRATEGY = PrimaryAlignmentStrategy.BestMapq;
    @Option(doc="For paired reads, soft clip the 3' end of each read if necessary so that it does not extend past the 5' end of its mate.")
    public boolean CLIP_OVERLAPPING_READS = true;
    @Option(doc="If false, do not write secondary alignments to output.")
    public boolean INCLUDE_SECONDARY_ALIGNMENTS = true;
    private static final Log log = Log.getInstance(MergeBamAlignment.class);

    public static void main(String[] stringArray) {
        System.exit(new MergeBamAlignment().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        SAMProgramRecord sAMProgramRecord = null;
        if (this.PROGRAM_RECORD_ID != null) {
            sAMProgramRecord = new SAMProgramRecord(this.PROGRAM_RECORD_ID);
            sAMProgramRecord.setProgramVersion(this.PROGRAM_GROUP_VERSION);
            sAMProgramRecord.setCommandLine(this.PROGRAM_GROUP_COMMAND_LINE);
            sAMProgramRecord.setProgramName(this.PROGRAM_GROUP_NAME);
        }
        if (this.JUMP_SIZE != null) {
            this.EXPECTED_ORIENTATIONS = Arrays.asList(SamPairUtil.PairOrientation.RF);
        } else if (this.EXPECTED_ORIENTATIONS == null || this.EXPECTED_ORIENTATIONS.isEmpty()) {
            this.EXPECTED_ORIENTATIONS = Arrays.asList(SamPairUtil.PairOrientation.FR);
        }
        SamAlignmentMerger samAlignmentMerger = new SamAlignmentMerger(this.UNMAPPED_BAM, this.OUTPUT, this.REFERENCE_SEQUENCE, sAMProgramRecord, this.CLIP_ADAPTERS, this.IS_BISULFITE_SEQUENCE, this.PAIRED_RUN, this.ALIGNED_READS_ONLY, this.ALIGNED_BAM, this.MAX_INSERTIONS_OR_DELETIONS, this.ATTRIBUTES_TO_RETAIN, this.READ1_TRIM, this.READ2_TRIM, this.READ1_ALIGNED_BAM, this.READ2_ALIGNED_BAM, this.EXPECTED_ORIENTATIONS, this.SORT_ORDER, this.PRIMARY_ALIGNMENT_STRATEGY.newInstance());
        samAlignmentMerger.setClipOverlappingReads(this.CLIP_OVERLAPPING_READS);
        samAlignmentMerger.setMaxRecordsInRam(this.MAX_RECORDS_IN_RAM);
        samAlignmentMerger.setKeepAlignerProperPairFlags(this.ALIGNER_PROPER_PAIR_FLAGS);
        samAlignmentMerger.setIncludeSecondaryAlignments(this.INCLUDE_SECONDARY_ALIGNMENTS);
        samAlignmentMerger.mergeAlignment();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        boolean bl;
        if (!(this.PROGRAM_RECORD_ID == null && this.PROGRAM_GROUP_VERSION == null && this.PROGRAM_GROUP_COMMAND_LINE == null || this.PROGRAM_RECORD_ID != null && this.PROGRAM_GROUP_VERSION != null && this.PROGRAM_GROUP_COMMAND_LINE != null)) {
            return new String[]{"PROGRAM_RECORD_ID, PROGRAM_GROUP_VERSION, and PROGRAM_GROUP_COMMAND_LINE must all be supplied or none should be included."};
        }
        boolean bl2 = this.READ1_ALIGNED_BAM != null && this.READ1_ALIGNED_BAM.size() > 0;
        boolean bl3 = bl = this.READ2_ALIGNED_BAM != null && this.READ2_ALIGNED_BAM.size() > 0;
        if (bl2 && !bl || bl && !bl2) {
            return new String[]{"READ1_ALIGNED_BAM and READ2_ALIGNED_BAM must both be supplied or neither should be included.  For single-end read use ALIGNED_BAM."};
        }
        if (this.ALIGNED_BAM == null || this.ALIGNED_BAM.size() == 0 && (!bl2 || !bl)) {
            return new String[]{"Either ALIGNED_BAM or the combination of READ1_ALIGNED_BAM and READ2_ALIGNED_BAM must be supplied."};
        }
        return null;
    }

    static enum PrimaryAlignmentStrategy {
        BestMapq(BestMapqPrimaryAlignmentSelectionStrategy.class),
        EarliestFragment(EarliestFragmentPrimaryAlignmentSelectionStrategy.class),
        BestEndMapq(BestEndMapqPrimaryAlignmentStrategy.class),
        MostDistant(MostDistantPrimaryAlignmentSelectionStrategy.class);

        private final Class<PrimaryAlignmentSelectionStrategy> clazz;

        private PrimaryAlignmentStrategy(Class<?> clazz) {
            this.clazz = clazz;
        }

        PrimaryAlignmentSelectionStrategy newInstance() {
            try {
                return this.clazz.newInstance();
            }
            catch (Exception exception) {
                throw new PicardException("Trouble instantiating " + this.clazz.getName(), exception);
            }
        }
    }
}

