/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordUtil;

public class RevertSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reverts SAM or BAM files to a previous state by removing certain types of information and/or " + "substituting in the original quality scores when available.";
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="Remove duplicate read flags from all reads.  Note that if this is true and REMOVE_ALIGNMENT_INFORMATION==false,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Option(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Option(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add("NM");
            this.add("UQ");
            this.add("PG");
            this.add("MD");
            this.add("MQ");
            this.add("SA");
        }
    };
    @Option(doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="ALIAS", optional=true)
    public String SAMPLE_ALIAS;
    @Option(doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="LIB", optional=true)
    public String LIBRARY_NAME;
    private static final Log log = Log.getInstance(RevertSam.class);

    public static void main(String[] stringArray) {
        System.exit(new RevertSam().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        boolean bl;
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT, true);
        SAMFileHeader sAMFileHeader = sAMFileReader.getFileHeader();
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        if (this.SAMPLE_ALIAS != null || this.LIBRARY_NAME != null) {
            bl = true;
            boolean bl2 = true;
            for (int i = 1; i < list.size(); ++i) {
                if (!list.get(0).getSample().equals(list.get(i).getSample())) {
                    bl = false;
                }
                if (list.get(0).getLibrary().equals(list.get(i).getLibrary())) continue;
                bl2 = false;
            }
            if (this.SAMPLE_ALIAS != null && !bl) {
                throw new PicardException("Read groups have multiple values for sample.  A value for SAMPLE_ALIAS cannot be supplied.");
            }
            if (this.LIBRARY_NAME != null && !bl2) {
                throw new PicardException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
            }
        }
        bl = sAMFileHeader.getSortOrder() == this.SORT_ORDER;
        SAMFileHeader sAMFileHeader2 = new SAMFileHeader();
        for (SAMReadGroupRecord object2 : sAMFileHeader.getReadGroups()) {
            if (this.SAMPLE_ALIAS != null) {
                object2.setSample(this.SAMPLE_ALIAS);
            }
            if (this.LIBRARY_NAME != null) {
                object2.setLibrary(this.LIBRARY_NAME);
            }
            sAMFileHeader2.addReadGroup(object2);
        }
        sAMFileHeader2.setSortOrder(this.SORT_ORDER);
        if (!this.REMOVE_ALIGNMENT_INFORMATION) {
            sAMFileHeader2.setSequenceDictionary(sAMFileHeader.getSequenceDictionary());
            sAMFileHeader2.setProgramRecords(sAMFileHeader.getProgramRecords());
        }
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader2, bl, this.OUTPUT);
        ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Reverted");
        for (SAMRecord sAMRecord : sAMFileReader) {
            Object object;
            if (sAMRecord.isSecondaryOrSupplementary()) continue;
            if (this.RESTORE_ORIGINAL_QUALITIES && (object = sAMRecord.getOriginalBaseQualities()) != null) {
                sAMRecord.setBaseQualities((byte[])object);
                sAMRecord.setOriginalBaseQualities(null);
            }
            if (this.REMOVE_DUPLICATE_INFORMATION) {
                sAMRecord.setDuplicateReadFlag(false);
            }
            if (this.REMOVE_ALIGNMENT_INFORMATION) {
                if (sAMRecord.getReadNegativeStrandFlag()) {
                    SAMRecordUtil.reverseComplement(sAMRecord);
                    sAMRecord.setReadNegativeStrandFlag(false);
                }
                sAMRecord.setReferenceIndex(-1);
                sAMRecord.setAlignmentStart(0);
                sAMRecord.setCigarString("*");
                sAMRecord.setMappingQuality(0);
                if (!sAMRecord.getReadUnmappedFlag()) {
                    sAMRecord.setInferredInsertSize(0);
                    sAMRecord.setNotPrimaryAlignmentFlag(false);
                    sAMRecord.setProperPairFlag(false);
                    sAMRecord.setReadUnmappedFlag(true);
                }
                if (sAMRecord.getReadPairedFlag()) {
                    sAMRecord.setMateAlignmentStart(0);
                    sAMRecord.setMateNegativeStrandFlag(false);
                    sAMRecord.setMateReferenceIndex(-1);
                    sAMRecord.setMateUnmappedFlag(true);
                }
                object = this.ATTRIBUTE_TO_CLEAR.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    sAMRecord.setAttribute(string2, null);
                }
            }
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
        }
        sAMFileWriter.close();
        return 0;
    }
}

