/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.MergingIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextComparator;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFUtils;

public class MergeVcfs
extends CommandLineProgram {
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Merges multiple VCF or BCF files into one VCF file. Input files must be sorted by their contigs " + "and, within contigs, by start position. The input files must have the same sample and " + "contig lists. An index file is created and a sequence dictionary is required by default.";
    @Option(shortName="I", doc="VCF or BCF input files File format is determined by file extension.", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="The merged VCF or BCF file. File format is determined by file extension.")
    public File OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionary in the input file", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] stringArray) {
        new MergeVcfs().instanceMainWithExit(stringArray);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        Object object;
        Object object2;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList(this.INPUT.size());
        HashSet<VCFHeader> hashSet = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        SAMSequenceDictionary sAMSequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            sAMSequenceDictionary = SAMFileReader.getSequenceDictionary(this.SEQUENCE_DICTIONARY);
        }
        for (File object32 : this.INPUT) {
            IoUtil.assertFileIsReadable(object32);
            object2 = new VCFFileReader(object32);
            object = ((VCFFileReader)object2).getFileHeader();
            if (variantContextComparator == null) {
                variantContextComparator = ((VCFHeader)object).getVCFRecordComparator();
            } else if (!variantContextComparator.isCompatible(((VCFHeader)object).getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + object32.getAbsolutePath() + " are not compatible with the others.");
            }
            if (sAMSequenceDictionary == null) {
                sAMSequenceDictionary = ((VCFHeader)object).getSequenceDictionary();
            }
            if (arrayList.isEmpty()) {
                arrayList.addAll(((VCFHeader)object).getSampleNamesInOrder());
            } else if (!arrayList.equals(((VCFHeader)object).getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + object32.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            hashSet.add((VCFHeader)object);
            arrayList2.add(((VCFFileReader)object2).iterator());
        }
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter variantContextWriter = VariantContextWriterFactory.create(this.OUTPUT, sAMSequenceDictionary, enumSet);
        variantContextWriter.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(hashSet, false), arrayList));
        object2 = new MergingIterator<VariantContext>(variantContextComparator, arrayList2);
        while (((MergingIterator)object2).hasNext()) {
            object = (VariantContext)((MergingIterator)object2).next();
            variantContextWriter.add((VariantContext)object);
            progressLogger.record(((VariantContext)object).getChr(), ((VariantContext)object).getStart());
        }
        CloserUtil.close(object2);
        variantContextWriter.close();
        return 0;
    }
}

