/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.RuntimeIOException;

public abstract class AbstractBAMFileIndex
implements BAMIndex {
    protected static final int BIN_GENOMIC_SPAN = 0x20000000;
    private static final int[] LEVEL_STARTS = new int[]{0, 1, 9, 73, 585, 4681};
    public static final int MAX_BINS = 37450;
    public static final int MAX_LINEAR_INDEX_SIZE = 37451 - LEVEL_STARTS[LEVEL_STARTS.length - 1];
    private final IndexFileBuffer mIndexBuffer;
    private SAMSequenceDictionary mBamDictionary = null;

    protected AbstractBAMFileIndex(SeekableStream seekableStream, SAMSequenceDictionary sAMSequenceDictionary) {
        this.mBamDictionary = sAMSequenceDictionary;
        this.mIndexBuffer = new IndexStreamBuffer(seekableStream);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        this(file, sAMSequenceDictionary, true);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        this.mBamDictionary = sAMSequenceDictionary;
        this.mIndexBuffer = bl ? new MemoryMappedFileBuffer(file) : new RandomAccessFileBuffer(file);
        this.seek(0);
        byte[] byArray = new byte[4];
        this.readBytes(byArray);
        if (!Arrays.equals(byArray, BAMFileConstants.BAM_INDEX_MAGIC)) {
            throw new RuntimeException("Invalid file header in BAM index " + file + ": " + new String(byArray));
        }
    }

    @Override
    public void close() {
        this.mIndexBuffer.close();
    }

    public static int getNumIndexLevels() {
        return LEVEL_STARTS.length;
    }

    public static int getFirstBinInLevel(int n) {
        return LEVEL_STARTS[n];
    }

    public int getLevelSize(int n) {
        if (n == AbstractBAMFileIndex.getNumIndexLevels()) {
            return 37451 - LEVEL_STARTS[n];
        }
        return LEVEL_STARTS[n + 1] - LEVEL_STARTS[n];
    }

    public int getLevelForBin(Bin bin) {
        if (bin.getBinNumber() >= 37450) {
            throw new SAMException("Tried to get level for invalid bin.");
        }
        for (int i = AbstractBAMFileIndex.getNumIndexLevels() - 1; i >= 0; --i) {
            if (bin.getBinNumber() < LEVEL_STARTS[i]) continue;
            return i;
        }
        throw new SAMException("Unable to find correct bin for bin " + bin);
    }

    public int getFirstLocusInBin(Bin bin) {
        int n = this.getLevelForBin(bin);
        int n2 = LEVEL_STARTS[n];
        int n3 = (n == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : LEVEL_STARTS[n + 1]) - n2;
        return (bin.getBinNumber() - n2) * (0x20000000 / n3) + 1;
    }

    public int getLastLocusInBin(Bin bin) {
        int n = this.getLevelForBin(bin);
        int n2 = LEVEL_STARTS[n];
        int n3 = (n == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : LEVEL_STARTS[n + 1]) - n2;
        return (bin.getBinNumber() - n2 + 1) * (0x20000000 / n3);
    }

    public int getNumberOfReferences() {
        this.seek(4);
        return this.readInteger();
    }

    @Override
    public long getStartOfLastLinearBin() {
        this.seek(4);
        int n = this.readInteger();
        long l = -1L;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.readInteger();
            for (n2 = 0; n2 < n3; ++n2) {
                this.skipBytes(4);
                int n4 = this.readInteger();
                this.skipBytes(16 * n4);
            }
            n2 = this.readInteger();
            if (n2 <= 0) continue;
            this.skipBytes(8 * (n2 - 1));
            l = this.readLong();
        }
        return l;
    }

    @Override
    public BAMIndexMetaData getMetaData(int n) {
        this.seek(4);
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n2 = this.readInteger();
        if (n >= n2) {
            return null;
        }
        this.skipToSequence(n);
        int n3 = this.readInteger();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.readInteger();
            int n5 = this.readInteger();
            Chunk chunk = null;
            if (n4 == 37450) {
                for (int j = 0; j < n5; ++j) {
                    long l = this.readLong();
                    long l2 = this.readLong();
                    chunk = new Chunk(l, l2);
                    arrayList.add(chunk);
                }
                continue;
            }
            this.skipBytes(16 * n5);
        }
        return new BAMIndexMetaData(arrayList);
    }

    public Long getNoCoordinateCount() {
        this.seek(4);
        int n = this.readInteger();
        this.skipToSequence(n);
        try {
            return this.readLong();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected BAMIndexContent query(int n, int n2, int n3) {
        Object object;
        int n4;
        int n5;
        int n6;
        this.seek(4);
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n7 = this.readInteger();
        if (n >= n7) {
            return null;
        }
        BitSet bitSet = this.regionToBins(n2, n3);
        if (bitSet == null) {
            return null;
        }
        this.skipToSequence(n);
        int n8 = this.readInteger();
        boolean bl = false;
        Bin[] binArray = new Bin[this.getMaxBinNumberForReference(n) + 1];
        for (n6 = 0; n6 < n8; ++n6) {
            long l;
            long l2;
            n5 = this.readInteger();
            n4 = this.readInteger();
            ArrayList<Chunk> arrayList2 = new ArrayList<Chunk>(n4);
            object = null;
            if (bitSet.get(n5)) {
                for (int i = 0; i < n4; ++i) {
                    l2 = this.readLong();
                    l = this.readLong();
                    object = new Chunk(l2, l);
                    arrayList2.add((Chunk)object);
                }
            } else {
                if (n5 == 37450) {
                    for (int i = 0; i < n4; ++i) {
                        l2 = this.readLong();
                        l = this.readLong();
                        object = new Chunk(l2, l);
                        arrayList.add((Chunk)object);
                    }
                    bl = true;
                    continue;
                }
                this.skipBytes(16 * n4);
            }
            Bin bin = new Bin(n, n5);
            bin.setChunkList(arrayList2);
            bin.setLastChunk((Chunk)object);
            binArray[n5] = bin;
        }
        n6 = this.readInteger();
        n5 = LinearIndex.convertToLinearIndexOffset(n2);
        n4 = n3 > 0 ? LinearIndex.convertToLinearIndexOffset(n3) : n6 - 1;
        int n9 = Math.min(n4, n6 - 1);
        object = new long[]{};
        if (n5 < n6) {
            object = new long[n9 - n5 + 1];
            this.skipBytes(8 * n5);
            for (int i = n5; i <= n9; ++i) {
                object[i - n5] = this.readLong();
            }
        }
        LinearIndex linearIndex = new LinearIndex(n, n5, (long[])object);
        return new BAMIndexContent(n, binArray, n8 - (bl ? 1 : 0), new BAMIndexMetaData(arrayList), linearIndex);
    }

    private int getMaxBinNumberForReference(int n) {
        try {
            int n2 = this.mBamDictionary.getSequence(n).getSequenceLength();
            return AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(n2);
        }
        catch (Exception exception) {
            return 37450;
        }
    }

    static int getMaxBinNumberForSequenceLength(int n) {
        return AbstractBAMFileIndex.getFirstBinInLevel(AbstractBAMFileIndex.getNumIndexLevels() - 1) + (n >> 14);
    }

    protected abstract BAMIndexContent getQueryResults(int var1);

    protected int getMaxAddressibleGenomicLocation() {
        return 0x20000000;
    }

    protected BitSet regionToBins(int n, int n2) {
        int n3;
        int n4;
        int n5 = n <= 0 ? 0 : n - 1 & 0x1FFFFFFF;
        int n6 = n4 = n2 <= 0 ? 0x1FFFFFFF : n2 - 1 & 0x1FFFFFFF;
        if (n5 > n4) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        for (n3 = 1 + (n5 >> 26); n3 <= 1 + (n4 >> 26); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 9 + (n5 >> 23); n3 <= 9 + (n4 >> 23); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 73 + (n5 >> 20); n3 <= 73 + (n4 >> 20); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 585 + (n5 >> 17); n3 <= 585 + (n4 >> 17); ++n3) {
            bitSet.set(n3);
        }
        for (n3 = 4681 + (n5 >> 14); n3 <= 4681 + (n4 >> 14); ++n3) {
            bitSet.set(n3);
        }
        return bitSet;
    }

    protected List<Chunk> optimizeChunkList(List<Chunk> list, long l) {
        Chunk chunk = null;
        Collections.sort(list);
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (Chunk chunk2 : list) {
            if (chunk2.getChunkEnd() <= l) continue;
            if (arrayList.isEmpty()) {
                arrayList.add(chunk2);
                chunk = chunk2;
                continue;
            }
            if (!chunk.overlaps(chunk2) && !chunk.isAdjacentTo(chunk2)) {
                arrayList.add(chunk2);
                chunk = chunk2;
                continue;
            }
            if (chunk2.getChunkEnd() <= chunk.getChunkEnd()) continue;
            chunk.setChunkEnd(chunk2.getChunkEnd());
        }
        return arrayList;
    }

    private void skipToSequence(int n) {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.readInteger();
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = this.readInteger();
                int n5 = this.readInteger();
                this.skipBytes(16 * n5);
            }
            n2 = this.readInteger();
            this.skipBytes(8 * n2);
        }
    }

    private void readBytes(byte[] byArray) {
        this.mIndexBuffer.readBytes(byArray);
    }

    private int readInteger() {
        return this.mIndexBuffer.readInteger();
    }

    private long readLong() {
        return this.mIndexBuffer.readLong();
    }

    private void skipBytes(int n) {
        this.mIndexBuffer.skipBytes(n);
    }

    private void seek(int n) {
        this.mIndexBuffer.seek(n);
    }

    private static class IndexStreamBuffer
    extends IndexFileBuffer {
        private final SeekableStream in;
        private final ByteBuffer tmpBuf;

        public IndexStreamBuffer(SeekableStream seekableStream) {
            this.in = seekableStream;
            this.tmpBuf = ByteBuffer.allocate(8);
            this.tmpBuf.order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public void close() {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }

        @Override
        public void readBytes(byte[] byArray) {
            try {
                this.in.read(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }

        @Override
        public void seek(int n) {
            try {
                this.in.seek(n);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }

        @Override
        public int readInteger() {
            try {
                int n = this.in.read(this.tmpBuf.array(), 0, 4);
                if (n != 4) {
                    throw new RuntimeIOException("Expected 4 bytes, got " + n);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
            return this.tmpBuf.getInt(0);
        }

        @Override
        public long readLong() {
            try {
                int n = this.in.read(this.tmpBuf.array(), 0, 8);
                if (n != 8) {
                    throw new RuntimeIOException("Expected 8 bytes, got " + n);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
            return this.tmpBuf.getLong(0);
        }

        @Override
        public void skipBytes(int n) {
            try {
                int n2;
                for (int i = n; i > 0; i -= n2) {
                    n2 = (int)this.in.skip(i);
                    if (n2 > 0) continue;
                    throw new RuntimeIOException("Failed to skip " + i);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }
    }

    private static class RandomAccessFileBuffer
    extends IndexFileBuffer {
        private static final int PAGE_SIZE = 4096;
        private static final int PAGE_OFFSET_MASK = 4095;
        private static final int PAGE_MASK = -4096;
        private static final int INVALID_PAGE = 1;
        private File mFile;
        private RandomAccessFile mRandomAccessFile;
        private int mFileLength;
        private int mFilePointer = 0;
        private int mCurrentPage = 1;
        private final byte[] mBuffer = new byte[4096];

        RandomAccessFileBuffer(File file) {
            this.mFile = file;
            try {
                this.mRandomAccessFile = new RandomAccessFile(file, "r");
                long l = this.mRandomAccessFile.length();
                if (l > Integer.MAX_VALUE) {
                    throw new RuntimeException("BAM index file " + this.mFile + " is too large: " + l);
                }
                this.mFileLength = (int)l;
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException.getMessage(), iOException);
            }
        }

        @Override
        void readBytes(byte[] byArray) {
            int n = 0;
            int n2 = byArray.length;
            if (this.mFilePointer + n2 > this.mFileLength) {
                throw new RuntimeException("Attempt to read past end of BAM index file (file is truncated?): " + this.mFile);
            }
            while (n2 > 0) {
                this.loadPage(this.mFilePointer);
                int n3 = this.mFilePointer & 0xFFF;
                int n4 = Math.min(n2, 4096 - n3);
                System.arraycopy(this.mBuffer, n3, byArray, n, n4);
                this.mFilePointer += n4;
                n += n4;
                n2 -= n4;
            }
        }

        @Override
        int readInteger() {
            this.loadPage(this.mFilePointer);
            int n = this.mFilePointer & 0xFFF;
            this.mFilePointer += 4;
            return this.mBuffer[n + 0] & 0xFF | (this.mBuffer[n + 1] & 0xFF) << 8 | (this.mBuffer[n + 2] & 0xFF) << 16 | (this.mBuffer[n + 3] & 0xFF) << 24;
        }

        @Override
        long readLong() {
            long l = this.readInteger();
            long l2 = this.readInteger();
            return l2 << 32 | l & 0xFFFFFFFFL;
        }

        @Override
        void skipBytes(int n) {
            this.mFilePointer += n;
        }

        @Override
        void seek(int n) {
            this.mFilePointer = n;
        }

        @Override
        void close() {
            this.mFilePointer = 0;
            this.mCurrentPage = 1;
            if (this.mRandomAccessFile != null) {
                try {
                    this.mRandomAccessFile.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException(iOException.getMessage(), iOException);
                }
                this.mRandomAccessFile = null;
            }
        }

        private void loadPage(int n) {
            int n2 = n & 0xFFFFF000;
            if (n2 == this.mCurrentPage) {
                return;
            }
            try {
                this.mRandomAccessFile.seek(n2);
                int n3 = Math.min(this.mFileLength - n2, 4096);
                this.mRandomAccessFile.readFully(this.mBuffer, 0, n3);
                this.mCurrentPage = n2;
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Exception reading BAM index file " + this.mFile + ": " + iOException.getMessage(), iOException);
            }
        }
    }

    private static class MemoryMappedFileBuffer
    extends IndexFileBuffer {
        private MappedByteBuffer mFileBuffer;

        MemoryMappedFileBuffer(File file) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                this.mFileBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                this.mFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
                fileChannel.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException.getMessage(), iOException);
            }
        }

        @Override
        void readBytes(byte[] byArray) {
            this.mFileBuffer.get(byArray);
        }

        @Override
        int readInteger() {
            return this.mFileBuffer.getInt();
        }

        @Override
        long readLong() {
            return this.mFileBuffer.getLong();
        }

        @Override
        void skipBytes(int n) {
            this.mFileBuffer.position(this.mFileBuffer.position() + n);
        }

        @Override
        void seek(int n) {
            this.mFileBuffer.position(n);
        }

        @Override
        void close() {
            this.mFileBuffer = null;
        }
    }

    private static abstract class IndexFileBuffer {
        private IndexFileBuffer() {
        }

        abstract void readBytes(byte[] var1);

        abstract int readInteger();

        abstract long readLong();

        abstract void skipBytes(int var1);

        abstract void seek(int var1);

        abstract void close();
    }
}

