/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.seekablestream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.HttpUtils;

public class SeekableHTTPStream
extends SeekableStream {
    private long position = 0L;
    private long contentLength = -1L;
    private final URL url;
    private final Proxy proxy;

    public SeekableHTTPStream(URL uRL) {
        this(uRL, null);
    }

    public SeekableHTTPStream(URL uRL, Proxy proxy) {
        this.proxy = proxy;
        this.url = uRL;
        String string2 = HttpUtils.getHeaderField(uRL, "Content-Length");
        if (string2 != null) {
            try {
                this.contentLength = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: Invalid content length (" + string2 + "  for: " + uRL);
                this.contentLength = -1L;
            }
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = Math.min(l, this.contentLength - this.position);
        this.position += l2;
        return l2;
    }

    @Override
    public boolean eof() throws IOException {
        return this.contentLength > 0L && this.position >= this.contentLength;
    }

    @Override
    public void seek(long l) {
        this.position = l;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Offset=" + n + ",len=" + n2 + ",buflen=" + byArray.length);
        }
        if (n2 == 0) {
            return 0;
        }
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        String string2 = "";
        int n3 = 0;
        try {
            int n4;
            httpURLConnection = this.proxy == null ? (HttpURLConnection)this.url.openConnection() : (HttpURLConnection)this.url.openConnection(this.proxy);
            long l = this.position + (long)n2 - 1L;
            if (this.contentLength > 0L) {
                l = Math.min(l, this.contentLength);
            }
            string2 = "bytes=" + this.position + "-" + l;
            httpURLConnection.setRequestProperty("Range", string2);
            inputStream = httpURLConnection.getInputStream();
            while (n3 < n2) {
                n4 = inputStream.read(byArray, n + n3, n2 - n3);
                if (n4 < 0) {
                    if (n3 != 0) break;
                    int n5 = -1;
                    return n5;
                }
                n3 += n4;
            }
            this.position += (long)n3;
            n4 = n3;
            return n4;
        }
        catch (IOException iOException) {
            if (iOException.getMessage().contains("416") || iOException instanceof EOFException) {
                if (n3 == 0) {
                    int n6 = -1;
                    return n6;
                }
                this.position += (long)n3;
                this.contentLength = this.position;
                int n7 = n3;
                return n7;
            }
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        this.read(byArray, 0, 1);
        return byArray[0] & 0xFF;
    }

    @Override
    public String getSource() {
        return this.url.toString();
    }
}

