/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;

class FSyncManager {
    private EnvironmentImpl envImpl;
    private long timeout;
    private Latch fsyncLatch;
    private volatile boolean fsyncInProgress;
    private FSyncGroup nextFSyncWaiters;
    private StatGroup stats;
    private LongStat nFSyncRequests;
    private LongStat nFSyncs;
    private LongStat nTimeouts;

    FSyncManager(EnvironmentImpl envImpl) {
        this.timeout = envImpl.getConfigManager().getDuration(EnvironmentParams.LOG_FSYNC_TIMEOUT);
        this.envImpl = envImpl;
        this.fsyncLatch = new Latch("fsyncLatch");
        this.fsyncInProgress = false;
        this.nextFSyncWaiters = new FSyncGroup(this.timeout, envImpl);
        this.stats = new StatGroup("FSyncManager", "FSyncManager statistics");
        this.nFSyncRequests = new LongStat(this.stats, LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS);
        this.nFSyncs = new LongStat(this.stats, LogStatDefinition.FSYNCMGR_FSYNCS);
        this.nTimeouts = new LongStat(this.stats, LogStatDefinition.FSYNCMGR_FSYNC_TIMEOUTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync() throws DatabaseException {
        boolean doFsync = false;
        boolean isLeader = false;
        boolean needToWait = false;
        FSyncGroup inProgressGroup = null;
        FSyncGroup myGroup = null;
        Latch latch = this.fsyncLatch;
        synchronized (latch) {
            this.nFSyncRequests.increment();
            if (this.fsyncInProgress) {
                needToWait = true;
                myGroup = this.nextFSyncWaiters;
            } else {
                isLeader = true;
                doFsync = true;
                this.fsyncInProgress = true;
                inProgressGroup = this.nextFSyncWaiters;
                this.nextFSyncWaiters = new FSyncGroup(this.timeout, this.envImpl);
            }
        }
        if (needToWait) {
            int waitStatus = myGroup.waitForFsync();
            if (waitStatus == FSyncGroup.DO_LEADER_FSYNC) {
                Latch latch2 = this.fsyncLatch;
                synchronized (latch2) {
                    if (this.fsyncInProgress) {
                        doFsync = true;
                    } else {
                        isLeader = true;
                        doFsync = true;
                        this.fsyncInProgress = true;
                        inProgressGroup = myGroup;
                        this.nextFSyncWaiters = new FSyncGroup(this.timeout, this.envImpl);
                    }
                }
            }
            if (waitStatus == FSyncGroup.DO_TIMEOUT_FSYNC) {
                doFsync = true;
                Latch latch3 = this.fsyncLatch;
                synchronized (latch3) {
                    this.nTimeouts.increment();
                }
            }
        }
        if (doFsync) {
            this.executeFSync();
            Latch latch4 = this.fsyncLatch;
            synchronized (latch4) {
                this.nFSyncs.increment();
                if (isLeader) {
                    inProgressGroup.wakeupAll();
                    this.nextFSyncWaiters.wakeupOne();
                    this.fsyncInProgress = false;
                }
            }
        }
    }

    long getNFSyncRequests() {
        return this.nFSyncRequests.get();
    }

    long getNFSyncs() {
        return this.nFSyncs.get();
    }

    long getNTimeouts() {
        return this.nTimeouts.get();
    }

    StatGroup loadStats(StatsConfig config) {
        return this.stats.cloneGroup(config.getClear());
    }

    protected void executeFSync() throws DatabaseException {
        this.envImpl.getFileManager().syncLogEnd();
    }

    static class FSyncGroup {
        static int DO_TIMEOUT_FSYNC = 0;
        static int DO_LEADER_FSYNC = 1;
        static int NO_FSYNC_NEEDED = 2;
        private volatile boolean fsyncDone;
        private long fsyncTimeout;
        private boolean leaderExists;
        private EnvironmentImpl envImpl;

        FSyncGroup(long fsyncTimeout, EnvironmentImpl envImpl) {
            this.fsyncTimeout = fsyncTimeout;
            this.fsyncDone = false;
            this.leaderExists = false;
            this.envImpl = envImpl;
        }

        synchronized boolean getLeader() {
            if (this.fsyncDone) {
                return false;
            }
            if (this.leaderExists) {
                return false;
            }
            this.leaderExists = true;
            return true;
        }

        synchronized int waitForFsync() throws ThreadInterruptedException {
            int status;
            block5: {
                long now2;
                status = 0;
                if (this.fsyncDone) break block5;
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        this.wait(this.fsyncTimeout);
                    }
                    catch (InterruptedException e) {
                        throw new ThreadInterruptedException(this.envImpl, "Unexpected interrupt while waiting for fsync", (Throwable)e);
                    }
                    if (this.fsyncDone) {
                        status = NO_FSYNC_NEEDED;
                    } else {
                        if (this.leaderExists) continue;
                        this.leaderExists = true;
                        status = DO_LEADER_FSYNC;
                    }
                    break block5;
                } while ((now2 = System.currentTimeMillis()) - startTime <= this.fsyncTimeout);
                status = DO_TIMEOUT_FSYNC;
            }
            return status;
        }

        synchronized void wakeupAll() {
            this.fsyncDone = true;
            this.notifyAll();
        }

        synchronized void wakeupOne() {
            this.notify();
        }
    }
}

