/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.PerTileParser;
import net.sf.picard.illumina.parser.readers.BarcodeFileReader;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CollectionUtil;

class BarcodeParser
extends PerTileParser<BarcodeData> {
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Barcodes));

    public BarcodeParser(IlluminaFileMap illuminaFileMap) {
        super(illuminaFileMap);
    }

    public BarcodeParser(IlluminaFileMap illuminaFileMap, int n) {
        super(illuminaFileMap, n);
    }

    @Override
    protected CloseableIterator<BarcodeData> makeTileIterator(File file) {
        return new BarcodeDataIterator(file);
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    private static class BarcodeDataIterator
    implements CloseableIterator<BarcodeData> {
        private BarcodeFileReader bfr;

        public BarcodeDataIterator(File file) {
            this.bfr = new BarcodeFileReader(file);
        }

        @Override
        public void close() {
            this.bfr.close();
        }

        @Override
        public boolean hasNext() {
            return this.bfr.hasNext();
        }

        @Override
        public BarcodeData next() {
            return new BarcodeData(){

                @Override
                public String getBarcode() {
                    return BarcodeDataIterator.this.bfr.next();
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

