/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.liftover;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Interval;
import net.sf.picard.util.OverlapDetector;
import net.sf.samtools.util.BufferedLineReader;

class Chain {
    private static final Pattern SPLITTER = Pattern.compile("\\s");
    final double score;
    final Interval interval;
    final String fromSequenceName;
    final int fromSequenceSize;
    final int fromChainStart;
    final int fromChainEnd;
    final String toSequenceName;
    final int toSequenceSize;
    final boolean toNegativeStrand;
    final int toChainStart;
    final int toChainEnd;
    final int id;
    private final List<ContinuousBlock> blockList = new ArrayList<ContinuousBlock>();

    private Chain(double d, String string2, int n, int n2, int n3, String string3, int n4, boolean bl, int n5, int n6, int n7) {
        this.interval = new Interval(string2, n2 + 1, n3);
        this.score = d;
        this.toChainEnd = n6;
        this.toSequenceName = string3;
        this.toNegativeStrand = bl;
        this.toSequenceSize = n4;
        this.toChainStart = n5;
        this.fromChainEnd = n3;
        this.fromSequenceName = string2;
        this.fromSequenceSize = n;
        this.fromChainStart = n2;
        this.id = n7;
    }

    private void addBlock(int n, int n2, int n3) {
        this.blockList.add(new ContinuousBlock(n, n2, n3));
    }

    ContinuousBlock getBlock(int n) {
        return this.blockList.get(n);
    }

    List<ContinuousBlock> getBlocks() {
        return Collections.unmodifiableList(this.blockList);
    }

    void write(PrintWriter printWriter) {
        printWriter.printf("chain\t%f\t%s\t%d\t+\t%d\t%d\t%s\t%d\t%s\t%d\t%d\t%d\n", this.score, this.fromSequenceName, this.fromSequenceSize, this.fromChainStart, this.fromChainEnd, this.toSequenceName, this.toSequenceSize, this.toNegativeStrand ? "-" : "+", this.toChainStart, this.toChainEnd, this.id);
        for (int i = 0; i < this.blockList.size() - 1; ++i) {
            ContinuousBlock continuousBlock = this.blockList.get(i);
            ContinuousBlock continuousBlock2 = this.blockList.get(i + 1);
            int n = continuousBlock2.fromStart - continuousBlock.getFromEnd();
            int n2 = continuousBlock2.toStart - continuousBlock.getToEnd();
            printWriter.printf("%d\t%d\t%d\n", continuousBlock.blockLength, n, n2);
        }
        printWriter.printf("%d\n", this.blockList.get((int)(this.blockList.size() - 1)).blockLength);
        printWriter.println();
    }

    void validate() {
        this.validatePositive("fromSequenceSize", this.fromSequenceSize);
        this.validateNonNegative("fromChainStart", this.fromChainStart);
        this.validateNonNegative("fromChainEnd", this.fromChainEnd);
        this.validatePositive("toSequenceSize", this.toSequenceSize);
        this.validateNonNegative("toChainStart", this.toChainStart);
        this.validateNonNegative("toChainEnd", this.toChainEnd);
        int n = this.fromChainEnd - this.fromChainStart;
        this.validatePositive("from length", n);
        int n2 = this.toChainEnd - this.toChainStart;
        this.validatePositive("to length", n2);
        if (n > this.fromSequenceSize) {
            throw new PicardException("From chain length (" + n + ") < from sequence length (" + this.fromSequenceSize + ") for chain " + this.id);
        }
        if (n2 > this.toSequenceSize) {
            throw new PicardException("To chain length (" + n2 + ") < to sequence length (" + this.toSequenceSize + ") for chain " + this.id);
        }
        if (this.fromSequenceName.isEmpty()) {
            throw new PicardException("Chain " + this.id + "has empty from sequence name.");
        }
        if (this.toSequenceName.isEmpty()) {
            throw new PicardException("Chain " + this.id + "has empty to sequence name.");
        }
        if (this.blockList.isEmpty()) {
            throw new PicardException("Chain " + this.id + " has empty block list.");
        }
        ContinuousBlock continuousBlock = this.blockList.get(0);
        if (continuousBlock.fromStart != this.fromChainStart) {
            throw new PicardException("First block from start != chain from start for chain " + this.id);
        }
        if (continuousBlock.toStart != this.toChainStart) {
            throw new PicardException("First block to start != chain to start for chain " + this.id);
        }
        ContinuousBlock continuousBlock2 = this.blockList.get(this.blockList.size() - 1);
        if (continuousBlock2.getFromEnd() != this.fromChainEnd) {
            throw new PicardException("Last block from end != chain from end for chain " + this.id);
        }
        if (continuousBlock2.getToEnd() != this.toChainEnd) {
            throw new PicardException("Last block to end < chain to end for chain " + this.id);
        }
        for (int i = 1; i < this.blockList.size(); ++i) {
            ContinuousBlock continuousBlock3 = this.blockList.get(i);
            ContinuousBlock continuousBlock4 = this.blockList.get(i - 1);
            if (continuousBlock3.fromStart < continuousBlock4.getFromEnd()) {
                throw new PicardException("Continuous block " + i + " from starts before previous block ends for chain " + this.id);
            }
            if (continuousBlock3.toStart >= continuousBlock4.getToEnd()) continue;
            throw new PicardException("Continuous block " + i + " to starts before previous block ends for chain " + this.id);
        }
    }

    private void validatePositive(String string2, int n) {
        if (n <= 0) {
            throw new PicardException(string2 + " is not positive: " + n + " for chain " + this.id);
        }
    }

    private void validateNonNegative(String string2, int n) {
        if (n < 0) {
            throw new PicardException(string2 + " is negative: " + n + " for chain " + this.id);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Chain chain2 = (Chain)object;
        if (this.fromChainEnd != chain2.fromChainEnd) {
            return false;
        }
        if (this.fromChainStart != chain2.fromChainStart) {
            return false;
        }
        if (this.fromSequenceSize != chain2.fromSequenceSize) {
            return false;
        }
        if (this.id != chain2.id) {
            return false;
        }
        if (Double.compare(chain2.score, this.score) != 0) {
            return false;
        }
        if (this.toChainEnd != chain2.toChainEnd) {
            return false;
        }
        if (this.toChainStart != chain2.toChainStart) {
            return false;
        }
        if (this.toNegativeStrand != chain2.toNegativeStrand) {
            return false;
        }
        if (this.toSequenceSize != chain2.toSequenceSize) {
            return false;
        }
        if (this.blockList != null ? !this.blockList.equals(chain2.blockList) : chain2.blockList != null) {
            return false;
        }
        if (this.fromSequenceName != null ? !this.fromSequenceName.equals(chain2.fromSequenceName) : chain2.fromSequenceName != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(chain2.interval) : chain2.interval != null) {
            return false;
        }
        return !(this.toSequenceName != null ? !this.toSequenceName.equals(chain2.toSequenceName) : chain2.toSequenceName != null);
    }

    public int hashCode() {
        long l = this.score != 0.0 ? Double.doubleToLongBits(this.score) : 0L;
        int n = (int)(l ^ l >>> 32);
        n = 31 * n + (this.interval != null ? this.interval.hashCode() : 0);
        n = 31 * n + (this.fromSequenceName != null ? this.fromSequenceName.hashCode() : 0);
        n = 31 * n + this.fromSequenceSize;
        n = 31 * n + this.fromChainStart;
        n = 31 * n + this.fromChainEnd;
        n = 31 * n + (this.toSequenceName != null ? this.toSequenceName.hashCode() : 0);
        n = 31 * n + this.toSequenceSize;
        n = 31 * n + (this.toNegativeStrand ? 1 : 0);
        n = 31 * n + this.toChainStart;
        n = 31 * n + this.toChainEnd;
        n = 31 * n + this.id;
        n = 31 * n + (this.blockList != null ? this.blockList.hashCode() : 0);
        return n;
    }

    static OverlapDetector<Chain> loadChains(File file) {
        Chain chain2;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        BufferedLineReader bufferedLineReader = new BufferedLineReader(IoUtil.openFileForReading(file));
        OverlapDetector<Chain> overlapDetector = new OverlapDetector<Chain>(0, 0);
        while ((chain2 = Chain.loadChain(bufferedLineReader, file.toString())) != null) {
            if (hashSet.contains(chain2.id)) {
                throw new PicardException("Chain id " + chain2.id + " appears more than once in chain file.");
            }
            hashSet.add(chain2.id);
            overlapDetector.addLhs(chain2, chain2.interval);
        }
        bufferedLineReader.close();
        return overlapDetector;
    }

    private static Chain loadChain(BufferedLineReader bufferedLineReader, String string2) {
        String string3 = bufferedLineReader.readLine();
        if (string3 == null) {
            return null;
        }
        String[] stringArray = SPLITTER.split(string3);
        if (stringArray.length != 13) {
            Chain.throwChainFileParseException("chain line has wrong number of fields", string2, bufferedLineReader.getLineNumber());
        }
        if (!"chain".equals(stringArray[0])) {
            Chain.throwChainFileParseException("chain line does not start with 'chain'", string2, bufferedLineReader.getLineNumber());
        }
        double d = 0.0;
        String string4 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string5 = null;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            d = Double.parseDouble(stringArray[1]);
            string4 = stringArray[2];
            n = Integer.parseInt(stringArray[3]);
            n2 = Integer.parseInt(stringArray[5]);
            n3 = Integer.parseInt(stringArray[6]);
            string5 = stringArray[7];
            n4 = Integer.parseInt(stringArray[8]);
            bl = stringArray[9].equals("-");
            n5 = Integer.parseInt(stringArray[10]);
            n6 = Integer.parseInt(stringArray[11]);
            n7 = Integer.parseInt(stringArray[12]);
        }
        catch (NumberFormatException numberFormatException) {
            Chain.throwChainFileParseException("Invalid field", string2, bufferedLineReader.getLineNumber());
        }
        Chain chain2 = new Chain(d, string4, n, n2, n3, string5, n4, bl, n5, n6, n7);
        int n8 = chain2.toChainStart;
        int n9 = chain2.fromChainStart;
        boolean bl2 = false;
        while (true) {
            String[] stringArray2;
            if ((string3 = bufferedLineReader.readLine()) == null || string3.equals("")) {
                if (bl2) break;
                Chain.throwChainFileParseException("Reached end of chain without seeing terminal block", string2, bufferedLineReader.getLineNumber());
                break;
            }
            if (bl2) {
                Chain.throwChainFileParseException("Terminal block seen before end of chain", string2, bufferedLineReader.getLineNumber());
            }
            if ((stringArray2 = SPLITTER.split(string3)).length == 1) {
                bl2 = true;
            } else if (stringArray2.length != 3) {
                Chain.throwChainFileParseException("Block line has unexpected number of fields", string2, bufferedLineReader.getLineNumber());
            }
            int n10 = Integer.parseInt(stringArray2[0]);
            chain2.addBlock(n9, n8, n10);
            if (bl2) continue;
            n9 += Integer.parseInt(stringArray2[1]) + n10;
            n8 += Integer.parseInt(stringArray2[2]) + n10;
        }
        chain2.validate();
        return chain2;
    }

    private static void throwChainFileParseException(String string2, String string3, int n) {
        throw new PicardException(string2 + " in chain file " + string3 + " at line " + n);
    }

    static class ContinuousBlock {
        final int fromStart;
        final int toStart;
        final int blockLength;

        private ContinuousBlock(int n, int n2, int n3) {
            this.fromStart = n;
            this.toStart = n2;
            this.blockLength = n3;
        }

        int getFromEnd() {
            return this.fromStart + this.blockLength;
        }

        int getToEnd() {
            return this.toStart + this.blockLength;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ContinuousBlock continuousBlock = (ContinuousBlock)object;
            if (this.blockLength != continuousBlock.blockLength) {
                return false;
            }
            if (this.fromStart != continuousBlock.fromStart) {
                return false;
            }
            return this.toStart == continuousBlock.toStart;
        }

        public int hashCode() {
            int n = this.fromStart;
            n = 31 * n + this.toStart;
            n = 31 * n + this.blockLength;
            return n;
        }
    }
}

