/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.util.SequenceUtil;

public class IntervalListTools
extends CommandLineProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + " General tool for manipulating interval lists, " + "including sorting, merging, padding, uniqueifying. Default operation if given one or more inputs is to " + "merge and sort them.  Other options are controlled by arguments.";
    @Option(shortName="I", doc="One or more interval lists. If multiple interval lists are provided the output is theresult of merging the inputs.")
    public List<File> INPUT;
    @Option(doc="The output interval list file to write (if SCATTER_COUNT is 1) or the directory into which to write the scattered interval sub-directories (if SCATTER_COUNT > 1)", shortName="O", optional=true)
    public File OUTPUT;
    @Option(doc="The amount to pad each end of the intervals by before other operations are undertaken. Negative numbers are allowed and indicate intervals should be shrunk. Resulting intervals < 0 bases long will be removed.", optional=true)
    public int PADDING = 0;
    @Option(doc="If true, merge overlapping and adjacent intervals to create a list of unique intervals. Implies SORT=true")
    public boolean UNIQUE = false;
    @Option(doc="If true, sort the resulting interval list by coordinate.")
    public boolean SORT = true;
    @Option(doc="One or more lines of comment to add to the header of the output file.", optional=true)
    public List<String> COMMENT = null;
    @Option(doc="The number of files into which to scatter the resulting list by locus.")
    public int SCATTER_COUNT = 1;
    private final Log log = Log.getInstance(IntervalListTools.class);

    public static void main(String[] stringArray) {
        new IntervalListTools().instanceMainWithExit(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doWork() {
        void var2_5;
        Object object;
        HashSet<String> hashSet;
        Object object2;
        for (File object42 : this.INPUT) {
            IoUtil.assertFileIsReadable(object42);
        }
        if (this.OUTPUT != null) {
            if (this.SCATTER_COUNT == 1) {
                IoUtil.assertFileIsWritable(this.OUTPUT);
            } else {
                IoUtil.assertDirectoryIsWritable(this.OUTPUT);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (File file : this.INPUT) {
            object2 = IntervalList.fromFile(file);
            if (this.PADDING != 0) {
                hashSet = new IntervalList(((IntervalList)object2).getHeader());
                object = ((IntervalList)object2).iterator();
                while (object.hasNext()) {
                    int n;
                    Interval interval = object.next();
                    int n2 = interval.getStart() - this.PADDING;
                    if (n2 > (n = interval.getEnd() + this.PADDING)) continue;
                    Interval interval2 = new Interval(interval.getSequence(), n2, n, interval.isNegativeStrand(), interval.getName());
                    ((IntervalList)((Object)hashSet)).add(interval2);
                }
                arrayList.add(hashSet);
                continue;
            }
            arrayList.add(object2);
        }
        if (this.UNIQUE && !this.SORT) {
            this.log.warn("UNIQUE=true requires sorting but SORT=false was specified.  Sorting anyway!");
            this.SORT = true;
        }
        Object var2_4 = null;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            object2 = (IntervalList)iterator2.next();
            if (var2_5 == null) {
                IntervalList intervalList = object2;
                continue;
            }
            SequenceUtil.assertSequenceDictionariesEqual(var2_5.getHeader().getSequenceDictionary(), ((IntervalList)object2).getHeader().getSequenceDictionary());
            hashSet = ((IntervalList)object2).iterator();
            while (hashSet.hasNext()) {
                object = (Interval)hashSet.next();
                var2_5.add((Interval)object);
            }
        }
        if (this.SORT) {
            var2_5.sort();
        }
        List<Interval> list = this.UNIQUE ? var2_5.getUniqueIntervals() : var2_5.getIntervals();
        object2 = var2_5.getHeader();
        hashSet = new HashSet<String>();
        for (SAMProgramRecord sAMProgramRecord : ((SAMFileHeader)object2).getProgramRecords()) {
            hashSet.add(sAMProgramRecord.getId());
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (hashSet.contains(String.valueOf(i))) continue;
            SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(String.valueOf(i));
            sAMProgramRecord.setCommandLine(this.getCommandLine());
            sAMProgramRecord.setProgramName(this.getClass().getSimpleName());
            ((SAMFileHeader)object2).addProgramRecord(sAMProgramRecord);
            break;
        }
        if (this.COMMENT != null) {
            for (String string2 : this.COMMENT) {
                ((SAMFileHeader)object2).addComment(string2);
            }
        }
        IntervalList intervalList = new IntervalList((SAMFileHeader)object2);
        long l = 0L;
        for (Interval interval2 : list) {
            intervalList.add(interval2);
            l += (long)interval2.length();
        }
        int n = 0;
        if (this.OUTPUT != null) {
            if (this.SCATTER_COUNT == 1) {
                n = intervalList.size();
                intervalList.write(this.OUTPUT);
            } else {
                n = this.scatterIntervals(intervalList);
            }
        }
        this.log.info("Output " + n + " intervals totalling " + intervalList.getUniqueBaseCount() + " unique bases.");
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.SCATTER_COUNT < 1) {
            return new String[]{"SCATTER_COUNT must be greater than 0."};
        }
        return null;
    }

    private int scatterIntervals(IntervalList intervalList) {
        long l = Math.max((long)Math.floor((double)intervalList.getUniqueBaseCount() / (1.0 * (double)this.SCATTER_COUNT)), 1L);
        int n = 0;
        IntervalList intervalList2 = new IntervalList(intervalList.getHeader());
        int n2 = 1;
        Iterator<Interval> iterator2 = intervalList.iterator();
        int n3 = 0;
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        while (iterator2.hasNext() && n2 < this.SCATTER_COUNT) {
            Interval interval = iterator2.next();
            int n4 = n + interval.length();
            if ((long)n4 < l) {
                intervalList2.add(interval);
                ++n3;
                n += interval.length();
                continue;
            }
            if ((long)n4 == l) {
                intervalList2.add(interval);
                ++n3;
                intervalList2.write(this.createDirectoryAndGetScatterFile(decimalFormat.format(n2++)));
                intervalList2 = new IntervalList(intervalList.getHeader());
                n = 0;
                continue;
            }
            int n5 = 0;
            while ((long)n4 > l && n2 < this.SCATTER_COUNT) {
                int n6 = (int)(l - (long)n);
                Interval interval2 = new Interval(interval.getSequence(), interval.getStart() + n5, interval.getStart() + n5 + n6 - 1, interval.isNegativeStrand(), interval.getName());
                intervalList2.add(interval2);
                ++n3;
                intervalList2.write(this.createDirectoryAndGetScatterFile(decimalFormat.format(n2++)));
                intervalList2 = new IntervalList(intervalList.getHeader());
                n = 0;
                n4 = interval.length() - (n5 += n6);
            }
            if (n4 <= 0) continue;
            Interval interval3 = new Interval(interval.getSequence(), interval.getStart() + n5, interval.getEnd(), interval.isNegativeStrand(), interval.getName());
            intervalList2.add(interval3);
            ++n3;
            n = interval3.length();
        }
        while (iterator2.hasNext()) {
            intervalList2.add(iterator2.next());
            ++n3;
        }
        intervalList2.write(this.createDirectoryAndGetScatterFile(decimalFormat.format(n2)));
        return n3;
    }

    public static File getScatteredFileName(File file, int n, String string2) {
        return new File(file.getAbsolutePath() + "/temp_" + string2 + "_of_" + n + "/scattered.intervals");
    }

    private File createDirectoryAndGetScatterFile(String string2) {
        this.createDirectoryOrFail(this.OUTPUT);
        File file = IntervalListTools.getScatteredFileName(this.OUTPUT, this.SCATTER_COUNT, string2);
        this.createDirectoryOrFail(file.getParentFile());
        return file;
    }

    private void createDirectoryOrFail(File file) {
        if (!file.exists() && !file.mkdir()) {
            throw new PicardException("Unable to create directory: " + file.getAbsolutePath());
        }
    }
}

