/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.BAMIndexWriter;
import net.sf.samtools.Bin;
import net.sf.samtools.BinaryBAMIndexWriter;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.TextualBAMIndexWriter;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;

public class BAMIndexer {
    private final int numReferences;
    private final BAMIndexWriter outputWriter;
    private int currentReference = 0;
    private final BAMIndexBuilder indexBuilder;

    public BAMIndexer(File file, SAMFileHeader sAMFileHeader) {
        this.numReferences = sAMFileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(sAMFileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, file);
    }

    public BAMIndexer(OutputStream outputStream, SAMFileHeader sAMFileHeader) {
        this.numReferences = sAMFileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(sAMFileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, outputStream);
    }

    public void processAlignment(SAMRecord sAMRecord) {
        try {
            int n = sAMRecord.getReferenceIndex();
            if (n != -1 && n != this.currentReference) {
                this.advanceToReference(n);
            }
            this.indexBuilder.processAlignment(sAMRecord);
        }
        catch (Exception exception) {
            throw new SAMException("Exception creating BAM index for record " + sAMRecord, exception);
        }
    }

    public void finish() {
        this.advanceToReference(this.numReferences);
        this.outputWriter.writeNoCoordinateRecordCount(this.indexBuilder.getNoCoordinateRecordCount());
        this.outputWriter.close();
    }

    private void advanceToReference(int n) {
        while (this.currentReference < n) {
            BAMIndexContent bAMIndexContent = this.indexBuilder.processReference(this.currentReference);
            this.outputWriter.writeReference(bAMIndexContent);
            ++this.currentReference;
            this.indexBuilder.startNewReference();
        }
    }

    public static void createAndWriteIndex(File file, File file2, boolean bl) {
        CachingBAMFileIndex cachingBAMFileIndex = new CachingBAMFileIndex(file, null);
        int n = cachingBAMFileIndex.getNumberOfReferences();
        BAMIndexWriter bAMIndexWriter = bl ? new TextualBAMIndexWriter(n, file2) : new BinaryBAMIndexWriter(n, file2);
        try {
            for (int i = 0; i < n; ++i) {
                bAMIndexWriter.writeReference(cachingBAMFileIndex.getQueryResults(i));
            }
            bAMIndexWriter.writeNoCoordinateRecordCount(cachingBAMFileIndex.getNoCoordinateCount());
            bAMIndexWriter.close();
        }
        catch (Exception exception) {
            throw new SAMException("Exception creating BAM index", exception);
        }
    }

    private class BAMIndexBuilder {
        private final SAMFileHeader bamHeader;
        private Bin[] bins;
        private int binsSeen = 0;
        private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
        private int largestIndexSeen = -1;
        private BAMIndexMetaData indexStats = new BAMIndexMetaData();

        BAMIndexBuilder(SAMFileHeader sAMFileHeader) {
            this.bamHeader = sAMFileHeader;
        }

        public void processAlignment(SAMRecord sAMRecord) {
            Object object;
            int n;
            this.indexStats.recordMetaData(sAMRecord);
            int n2 = sAMRecord.getAlignmentStart();
            if (n2 == 0) {
                return;
            }
            int n3 = sAMRecord.getReferenceIndex();
            if (n3 != BAMIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + n3 + " when constructing index for " + BAMIndexer.this.currentReference + " for record " + sAMRecord);
            }
            Integer n4 = sAMRecord.getIndexingBin();
            int n5 = n = n4 == null ? sAMRecord.computeIndexingBin() : n4.intValue();
            if (this.bins == null) {
                object = this.bamHeader.getSequence(n3);
                this.bins = object == null ? new Bin[37451] : new Bin[AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(((SAMSequenceRecord)object).getSequenceLength()) + 1];
            }
            if (this.bins[n] != null) {
                object = this.bins[n];
            } else {
                this.bins[n] = object = new Bin(n3, n);
                ++this.binsSeen;
            }
            SAMFileSource sAMFileSource = sAMRecord.getFileSource();
            if (sAMFileSource == null) {
                throw new SAMException("No source (virtual file offsets); needed for indexing on BAM Record " + sAMRecord);
            }
            Chunk chunk = ((BAMFileSpan)sAMFileSource.getFilePointer()).getSingleChunk();
            long l = chunk.getChunkStart();
            long l2 = chunk.getChunkEnd();
            List<Chunk> list = ((Bin)object).getChunkList();
            if (!((Bin)object).containsChunks()) {
                ((Bin)object).addInitialChunk(chunk);
            } else {
                Chunk chunk2 = ((Bin)object).getLastChunk();
                if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(chunk2.getChunkEnd(), l)) {
                    chunk2.setChunkEnd(l2);
                } else {
                    list.add(chunk);
                    ((Bin)object).setLastChunk(chunk);
                }
            }
            int n6 = sAMRecord.getAlignmentEnd();
            int n7 = LinearIndex.convertToLinearIndexOffset(n2);
            int n8 = n6 == 0 ? (n7 = LinearIndex.convertToLinearIndexOffset(n2 - 1)) : LinearIndex.convertToLinearIndexOffset(n6);
            if (n8 > this.largestIndexSeen) {
                this.largestIndexSeen = n8;
            }
            for (int i = n7; i <= n8; ++i) {
                if (this.index[i] != 0L && l >= this.index[i]) continue;
                this.index[i] = l;
            }
        }

        public BAMIndexContent processReference(int n) {
            if (n != BAMIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + n + " when constructing index for " + BAMIndexer.this.currentReference);
            }
            if (this.binsSeen == 0) {
                return null;
            }
            long[] lArray = new long[this.largestIndexSeen + 1];
            long l = 0L;
            for (int i = 0; i <= this.largestIndexSeen; ++i) {
                if (this.index[i] == 0L) {
                    this.index[i] = l;
                } else {
                    l = this.index[i];
                }
                lArray[i] = this.index[i];
            }
            LinearIndex linearIndex = new LinearIndex(n, 0, lArray);
            return new BAMIndexContent(n, this.bins, this.binsSeen, this.indexStats, linearIndex);
        }

        public long getNoCoordinateRecordCount() {
            return this.indexStats.getNoCoordinateRecordCount();
        }

        void startNewReference() {
            this.bins = null;
            if (this.binsSeen > 0) {
                Arrays.fill(this.index, 0L);
            }
            this.binsSeen = 0;
            this.largestIndexSeen = -1;
            this.indexStats.newReference();
        }
    }
}

