/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.util.StringUtil;

public class TextCigarCodec {
    private static final byte ZERO_BYTE = "0".getBytes()[0];
    private static final byte NINE_BYTE = "9".getBytes()[0];
    private static final TextCigarCodec singleton = new TextCigarCodec();

    public static TextCigarCodec getSingleton() {
        return singleton;
    }

    public String encode(Cigar cigar) {
        if (cigar.isEmpty()) {
            return "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            stringBuilder.append(cigarElement.getLength());
            stringBuilder.append((Object)cigarElement.getOperator());
        }
        return stringBuilder.toString();
    }

    public Cigar decode(String string2) {
        if ("*".equals(string2)) {
            return new Cigar();
        }
        Cigar cigar = new Cigar();
        byte[] byArray = StringUtil.stringToBytes(string2);
        for (int i = 0; i < byArray.length; ++i) {
            if (!this.isDigit(byArray[i])) {
                throw new IllegalArgumentException("Malformed CIGAR string: " + string2);
            }
            int n = byArray[i] - ZERO_BYTE;
            ++i;
            while (this.isDigit(byArray[i])) {
                n = n * 10 + byArray[i] - ZERO_BYTE;
                ++i;
            }
            CigarOperator cigarOperator = CigarOperator.characterToEnum(byArray[i]);
            cigar.add(new CigarElement(n, cigarOperator));
        }
        return cigar;
    }

    private boolean isDigit(byte by2) {
        return by2 >= ZERO_BYTE && by2 <= NINE_BYTE;
    }
}

