/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.ParserVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNumberLiteral
extends JexlNode
implements JexlNode.Literal<Number> {
    Number literal = null;
    Class<?> clazz = null;

    public ASTNumberLiteral(int id) {
        super(id);
    }

    public ASTNumberLiteral(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Number getLiteral() {
        return this.literal;
    }

    @Override
    protected boolean isConstant(boolean literal) {
        return true;
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Class<?> getLiteralClass() {
        return this.clazz;
    }

    public boolean isInteger() {
        return Integer.class.equals(this.clazz);
    }

    public void setNatural(String s2) {
        Number result2;
        Class rclass;
        int base;
        if (s2.charAt(0) == '0') {
            if (s2.length() > 1 && (s2.charAt(1) == 'x' || s2.charAt(1) == 'X')) {
                base = 16;
                s2 = s2.substring(2);
            } else {
                base = 8;
            }
        } else {
            base = 10;
        }
        int last2 = s2.length() - 1;
        switch (s2.charAt(last2)) {
            case 'L': 
            case 'l': {
                rclass = Long.class;
                result2 = Long.valueOf(s2.substring(0, last2), base);
                break;
            }
            case 'H': 
            case 'h': {
                rclass = BigInteger.class;
                result2 = new BigInteger(s2.substring(0, last2), base);
                break;
            }
            default: {
                rclass = Integer.class;
                try {
                    result2 = Integer.valueOf(s2, base);
                    break;
                }
                catch (NumberFormatException take2) {
                    try {
                        result2 = Long.valueOf(s2, base);
                        break;
                    }
                    catch (NumberFormatException take3) {
                        result2 = new BigInteger(s2, base);
                    }
                }
            }
        }
        this.literal = result2;
        this.clazz = rclass;
    }

    public void setReal(String s2) {
        Class rclass;
        Number result2;
        int last2 = s2.length() - 1;
        switch (s2.charAt(last2)) {
            case 'B': 
            case 'b': {
                result2 = new BigDecimal(s2.substring(0, last2));
                rclass = BigDecimal.class;
                break;
            }
            case 'D': 
            case 'd': {
                rclass = Double.class;
                result2 = Double.valueOf(s2);
                break;
            }
            default: {
                rclass = Float.class;
                try {
                    result2 = Float.valueOf(s2);
                    break;
                }
                catch (NumberFormatException take2) {
                    try {
                        result2 = Double.valueOf(s2);
                        break;
                    }
                    catch (NumberFormatException take3) {
                        result2 = new BigDecimal(s2);
                    }
                }
            }
        }
        this.literal = result2;
        this.clazz = rclass;
    }
}

