/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;
import org.apache.tools.ant.util.KeepAliveInputStream;

public class DefaultInputHandler
implements InputHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleInput(InputRequest request) throws BuildException {
        String prompt = this.getPrompt(request);
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(this.getInputStream()));
            do {
                System.err.println(prompt);
                System.err.flush();
                try {
                    String input2 = r.readLine();
                    request.setInput(input2);
                }
                catch (IOException e) {
                    throw new BuildException("Failed to read input from Console.", e);
                }
            } while (!request.isInputValid());
            Object var6_6 = null;
            if (r == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new BuildException("Failed to close input.", e);
            }
        }
        try {
            r.close();
            return;
        }
        catch (IOException e) {
            throw new BuildException("Failed to close input.", e);
        }
    }

    protected String getPrompt(InputRequest request) {
        String prompt = request.getPrompt();
        String def = request.getDefaultValue();
        if (request instanceof MultipleChoiceInputRequest) {
            StringBuffer sb = new StringBuffer(prompt);
            sb.append(" (");
            Enumeration e = ((MultipleChoiceInputRequest)request).getChoices().elements();
            boolean first = true;
            while (e.hasMoreElements()) {
                String next2;
                if (!first) {
                    sb.append(", ");
                }
                if ((next2 = (String)e.nextElement()).equals(def)) {
                    sb.append('[');
                }
                sb.append(next2);
                if (next2.equals(def)) {
                    sb.append(']');
                }
                first = false;
            }
            sb.append(")");
            return sb.toString();
        }
        if (def != null) {
            return prompt + " [" + def + "]";
        }
        return prompt;
    }

    protected InputStream getInputStream() {
        return KeepAliveInputStream.wrapSystemIn();
    }
}

