/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.filewriter.ScoresFileWriter;

public class BarcodeScoresFileWriter
extends ScoresFileWriter {
    public BarcodeScoresFileWriter(boolean bl) {
        super(bl);
    }

    @Override
    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        if (this.isGct) {
            this.printGctPreamble(poolQScores, printWriter);
        }
        this.printConstructAndConstructIdColumns(printWriter);
        Map<String, SortedSet<String>> map2 = poolQScores.getConditionToBarcodeMap();
        for (String string2 : poolQScores.getConditions()) {
            for (String string3 : map2.get(string2)) {
                printWriter.append('\t').append(string3);
            }
        }
        printWriter.append('\n');
    }

    @Override
    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        Map<String, SortedSet<String>> map2 = poolQScores.getConditionToBarcodeMap();
        for (String string2 : poolQScores.getConstructBarcodes()) {
            Collection<String> collection = poolQScores.getIdsForConstructBarcode(string2);
            this.printConstructAndConstructIds(printWriter, string2, collection);
            Map<String, Integer> map3 = poolQScores.getScoresBySampleForConstruct(string2);
            for (String string3 : poolQScores.getConditions()) {
                for (String string4 : map2.get(string3)) {
                    Integer n = map3.get(string4);
                    if (n == null) {
                        n = 0;
                    }
                    printWriter.append('\t').append(n.toString());
                }
            }
            printWriter.append('\n');
        }
    }
}

