/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;

public final class BCF2Decoder {
    byte[] recordBytes = null;
    ByteArrayInputStream recordStream = null;

    public BCF2Decoder() {
    }

    protected BCF2Decoder(byte[] byArray) {
        this.setRecordBytes(byArray);
    }

    public void readNextBlock(int n, InputStream inputStream) {
        if (n < 0) {
            throw new TribbleException("Invalid block size " + n);
        }
        this.setRecordBytes(BCF2Decoder.readRecordBytes(n, inputStream));
    }

    public void skipNextBlock(int n, InputStream inputStream) {
        try {
            int n2 = (int)inputStream.skip(n);
            BCF2Decoder.validateReadBytes(n2, 1, n);
        }
        catch (IOException iOException) {
            throw new TribbleException("I/O error while reading BCF2 file", iOException);
        }
        this.recordBytes = null;
        this.recordStream = null;
    }

    public byte[] getRecordBytes() {
        return this.recordBytes;
    }

    public int getBlockSize() {
        return this.recordBytes.length;
    }

    public boolean blockIsFullyDecoded() {
        return this.recordStream.available() == 0;
    }

    @Requires(value={"recordBytes != null"})
    @Ensures(value={"this.recordBytes == recordBytes", "recordStream != null"})
    public void setRecordBytes(byte[] byArray) {
        this.recordBytes = byArray;
        this.recordStream = new ByteArrayInputStream(byArray);
    }

    public final Object decodeTypedValue() throws IOException {
        byte by2 = this.readTypeDescriptor();
        return this.decodeTypedValue(by2);
    }

    public final Object decodeTypedValue(byte by2) throws IOException {
        int n = this.decodeNumberOfElements(by2);
        return this.decodeTypedValue(by2, n);
    }

    @Requires(value={"size >= 0"})
    public final Object decodeTypedValue(byte by2, int n) throws IOException {
        if (n == 0) {
            return null;
        }
        BCF2Type bCF2Type = BCF2Utils.decodeType(by2);
        if (bCF2Type == BCF2Type.CHAR) {
            return this.decodeLiteralString(n);
        }
        if (n == 1) {
            return this.decodeSingleValue(bCF2Type);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = this.decodeSingleValue(bCF2Type);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    public final Object decodeSingleValue(BCF2Type bCF2Type) throws IOException {
        int n = this.decodeInt(bCF2Type);
        if (n == bCF2Type.getMissingBytes()) {
            return null;
        }
        switch (bCF2Type) {
            case INT8: 
            case INT16: 
            case INT32: {
                return n;
            }
            case FLOAT: {
                return this.rawFloatToFloat(n);
            }
            case CHAR: {
                return n & 0xFF;
            }
        }
        throw new TribbleException("BCF2 codec doesn't know how to decode type " + (Object)((Object)bCF2Type));
    }

    private final Object decodeLiteralString(int n) {
        assert (n > 0);
        byte[] byArray = new byte[n];
        try {
            int n2;
            this.recordStream.read(byArray);
            for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
            }
            if (n2 == 0) {
                return null;
            }
            String string2 = new String(byArray, 0, n2);
            return BCF2Utils.isCollapsedString(string2) ? BCF2Utils.explodeStringList(string2) : string2;
        }
        catch (IOException iOException) {
            throw new TribbleException("readByte failure", iOException);
        }
    }

    @Ensures(value={"result >= 0"})
    public final int decodeNumberOfElements(byte by2) throws IOException {
        if (BCF2Utils.sizeIsOverflow(by2)) {
            return this.decodeInt(this.readTypeDescriptor(), -1);
        }
        return BCF2Utils.decodeSize(by2);
    }

    @Requires(value={"BCF2Utils.decodeSize(typeDescriptor) == 1"})
    public final int decodeInt(byte by2, int n) throws IOException {
        BCF2Type bCF2Type = BCF2Utils.decodeType(by2);
        int n2 = this.decodeInt(bCF2Type);
        return n2 == bCF2Type.getMissingBytes() ? n : n2;
    }

    @Requires(value={"type != null"})
    public final int decodeInt(BCF2Type bCF2Type) throws IOException {
        return bCF2Type.read(this.recordStream);
    }

    @Requires(value={"type != null", "type.isIntegerType()", "size >= 0"})
    public final int[] decodeIntArray(int n, BCF2Type bCF2Type, int[] nArray) throws IOException {
        int n2;
        if (n == 0) {
            return null;
        }
        if (nArray != null && nArray.length < n) {
            nArray = null;
        }
        if ((n2 = this.decodeInt(bCF2Type)) == bCF2Type.getMissingBytes()) {
            for (int i = 1; i < n; ++i) {
                this.decodeInt(bCF2Type);
            }
            return null;
        }
        int[] nArray2 = nArray == null ? new int[n] : nArray;
        nArray2[0] = n2;
        for (int i = 1; i < n; ++i) {
            nArray2[i] = this.decodeInt(bCF2Type);
            if (nArray2[i] != bCF2Type.getMissingBytes()) continue;
            for (int j = i + 1; j < n; ++j) {
                this.decodeInt(bCF2Type);
            }
            return Arrays.copyOf(nArray2, i);
        }
        return nArray2;
    }

    public final int[] decodeIntArray(byte by2, int n) throws IOException {
        BCF2Type bCF2Type = BCF2Utils.decodeType(by2);
        return this.decodeIntArray(n, bCF2Type, null);
    }

    private double rawFloatToFloat(int n) {
        return Float.intBitsToFloat(n);
    }

    public final int readBlockSize(InputStream inputStream) throws IOException {
        return BCF2Type.INT32.read(inputStream);
    }

    @Requires(value={"blockSizeInBytes >= 0", "inputStream != null"})
    @Ensures(value={"result != null"})
    private static byte[] readRecordBytes(int n, InputStream inputStream) {
        assert (n >= 0);
        byte[] byArray = new byte[n];
        try {
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = inputStream.read(byArray, n2, n - n2);
                if (n4 == -1) {
                    BCF2Decoder.validateReadBytes(n2, n3, n);
                    continue;
                }
                n2 += n4;
            }
            BCF2Decoder.validateReadBytes(n2, n3, n);
        }
        catch (IOException iOException) {
            throw new TribbleException("I/O error while reading BCF2 file", iOException);
        }
        return byArray;
    }

    private static void validateReadBytes(int n, int n2, int n3) {
        assert (n3 >= 0);
        if (n < n3) {
            throw new TribbleException(String.format("Failed to read next complete record: expected %d bytes but read only %d after %d iterations", n3, n, n2));
        }
    }

    public final byte readTypeDescriptor() throws IOException {
        return BCF2Utils.readByte(this.recordStream);
    }
}

