/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.bcf2.BCF2Codec;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFHeader;

public class VCFFileReader
implements Closeable,
Iterable<VariantContext> {
    private final FeatureReader<VariantContext> reader;

    public static boolean isBCF(File file) {
        return file.getAbsolutePath().endsWith(".bcf");
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        SAMSequenceDictionary sAMSequenceDictionary = new VCFFileReader(file).getFileHeader().getSequenceDictionary();
        CloserUtil.close(file);
        return sAMSequenceDictionary;
    }

    public VCFFileReader(File file) {
        this(file, true);
    }

    public VCFFileReader(File file, boolean bl) {
        this.reader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), VCFFileReader.isBCF(file) ? new BCF2Codec() : new VCFCodec(), bl);
    }

    public VCFHeader getFileHeader() {
        return (VCFHeader)this.reader.getHeader();
    }

    @Override
    public CloseableIterator<VariantContext> iterator() {
        try {
            return this.reader.iterator();
        }
        catch (IOException iOException) {
            throw new TribbleException("Could not create an iterator from a feature reader.", iOException);
        }
    }

    public CloseableIterator<VariantContext> query(String string2, int n, int n2) {
        try {
            return this.reader.query(string2, n, n2);
        }
        catch (IOException iOException) {
            throw new TribbleException("Could not create an iterator from a feature reader.", iOException);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new TribbleException("Could not close a variant context feature reader.", iOException);
        }
    }
}

