/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DaemonRunner;
import com.sleepycat.je.utilint.ExceptionListenerUser;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DaemonThread
implements DaemonRunner,
Runnable,
ExceptionListenerUser {
    private static final int JOIN_MILLIS = 10;
    private long waitTime;
    private Object synchronizer = new Object();
    private Thread thread;
    private ExceptionListener exceptionListener;
    protected String name;
    protected int nWakeupRequests;
    public static boolean stifleExceptionChatter = false;
    private volatile boolean shutdownRequest = false;
    private volatile boolean paused = false;
    private boolean running = false;
    protected final EnvironmentImpl envImpl;
    private static final String ERROR_LISTENER = "setErrorListener";
    protected final Logger logger;

    public DaemonThread(long waitTime, String name, EnvironmentImpl envImpl) {
        this.waitTime = waitTime;
        String nodeName = envImpl.getNodeName();
        this.name = nodeName == null ? name : name + " (" + nodeName + ")";
        this.envImpl = envImpl;
        this.logger = this.createLogger();
        envImpl.registerExceptionListenerUser(this);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected Logger createLogger() {
        return LoggerUtils.getLogger(this.getClass());
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void runOrPause(boolean run2) {
        if (run2) {
            this.paused = false;
            if (this.thread != null) {
                this.wakeup();
            } else {
                this.thread = new Thread((Runnable)this, this.name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        } else {
            this.paused = true;
        }
    }

    public void requestShutdown() {
        this.shutdownRequest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.thread != null) {
            this.shutdownRequest = true;
            while (this.thread.isAlive()) {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.synchronizer.notifyAll();
                }
                try {
                    this.thread.join(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<DaemonThread name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (!this.paused) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdownRequest) {
            try {
                int numTries = 0;
                long maxRetries = this.nDeadlockRetries();
                while ((long)numTries <= maxRetries && !this.shutdownRequest && !this.paused) {
                    Object var6_8;
                    try {
                        try {
                            ++this.nWakeupRequests;
                            this.running = true;
                            this.onWakeup();
                            var6_8 = null;
                            this.running = false;
                            break;
                        }
                        catch (LockConflictException e) {
                            var6_8 = null;
                            this.running = false;
                        }
                    }
                    catch (Throwable throwable) {
                        var6_8 = null;
                        this.running = false;
                        throw throwable;
                    }
                    ++numTries;
                }
                if (this.shutdownRequest) continue;
                Object object = this.synchronizer;
                synchronized (object) {
                    if (this.waitTime == 0L || this.paused) {
                        this.synchronizer.wait();
                    } else {
                        this.synchronizer.wait(this.waitTime);
                    }
                }
            }
            catch (InterruptedException e) {
                if (this.exceptionListener != null) {
                    this.exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(e, this.name));
                }
                if (!stifleExceptionChatter) {
                    this.logger.info("Shutting down " + this + " due to exception: " + e);
                }
                this.shutdownRequest = true;
                assert (this.checkErrorListener(e));
            }
            catch (Exception e) {
                if (this.exceptionListener != null) {
                    this.exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(e, this.name));
                }
                if (!stifleExceptionChatter) {
                    this.logger.log(Level.SEVERE, this.toString() + " caught exception, " + e + (this.shutdownRequest ? " Exiting" : " Continuing"), e);
                }
                assert (this.checkErrorListener(e));
            }
            catch (Error e) {
                assert (this.checkErrorListener(e));
                this.envImpl.invalidate(e);
                this.shutdownRequest = true;
                this.logger.log(Level.SEVERE, "Error caught in " + this, e);
            }
        }
    }

    public boolean checkErrorListener(Throwable e) {
        if (Boolean.getBoolean(ERROR_LISTENER)) {
            if (!stifleExceptionChatter) {
                this.logger.severe(this.name + " " + LoggerUtils.getStackTrace(e));
            }
            new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.TEST_INVALIDATE, "Daemon thread failed during testing", e);
        }
        return true;
    }

    protected long nDeadlockRetries() {
        return 0L;
    }

    protected abstract void onWakeup() throws DatabaseException;

    protected boolean isShutdownRequested() {
        return this.shutdownRequest;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getNWakeupRequests() {
        return this.nWakeupRequests;
    }
}

