/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IntensityChannel;

public class FourChannelIntensityData {
    private short[] a;
    private short[] c;
    private short[] g;
    private short[] t;

    public FourChannelIntensityData(int n) {
        this.a = new short[n];
        this.c = new short[n];
        this.g = new short[n];
        this.t = new short[n];
    }

    public short[] getChannel(IntensityChannel intensityChannel) {
        switch (intensityChannel) {
            case A: {
                return this.a;
            }
            case C: {
                return this.c;
            }
            case G: {
                return this.g;
            }
            case T: {
                return this.t;
            }
        }
        throw new PicardException("Unexpected intensity channel " + (Object)((Object)intensityChannel));
    }

    public short[] getA() {
        return this.a;
    }

    public short[] getC() {
        return this.c;
    }

    public short[] getG() {
        return this.g;
    }

    public short[] getT() {
        return this.t;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FourChannelIntensityData fourChannelIntensityData = (FourChannelIntensityData)object;
        return Arrays.equals(this.a, fourChannelIntensityData.a) && Arrays.equals(this.c, fourChannelIntensityData.c) && Arrays.equals(this.g, fourChannelIntensityData.g) && Arrays.equals(this.t, fourChannelIntensityData.t);
    }

    public int hashCode() {
        int n = 0;
        n = n * 31 + Arrays.hashCode(this.a);
        n += n * 31 + Arrays.hashCode(this.c);
        n += n * 31 + Arrays.hashCode(this.g);
        n += n * 31 + Arrays.hashCode(this.t);
        return n;
    }
}

