/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.data;

import gnu.trove.map.TMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.rnai.poolq.api.BarcodeScore;
import org.broadinstitute.rnai.poolq.impl.ReadOnlyIterator;
import org.broadinstitute.rnai.poolq.impl.data.BarcodeToReadCounts;
import org.broadinstitute.rnai.poolq.impl.data.CoocurrenceDatabase;

public final class InMemoryCoocurrenceDatabase
implements CoocurrenceDatabase {
    private final List<String> barcodes;
    private final TMap<String, TObjectIntMap<String>> barcodeToScoresMap = new THashMap<String, TObjectIntMap<String>>();

    public InMemoryCoocurrenceDatabase(List<String> list) {
        this.barcodes = list;
    }

    @Override
    public void increment(String string2, String string3) {
        TObjectIntMap<String> tObjectIntMap = this.getScoresMapForConstructBarcode(string2);
        tObjectIntMap.adjustOrPutValue(string3, 1, 1);
    }

    @Override
    public Iterator<BarcodeScore> iterator() {
        return new ReadOnlyIterator<BarcodeScore>(){
            private final Iterator<Map.Entry<String, TObjectIntMap<String>>> entryIterator;
            {
                this.entryIterator = InMemoryCoocurrenceDatabase.this.barcodeToScoresMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public BarcodeScore next() {
                Map.Entry<String, TObjectIntMap<String>> entry = this.entryIterator.next();
                String string2 = entry.getKey();
                TObjectIntMap<String> tObjectIntMap = entry.getValue();
                final BarcodeToReadCounts barcodeToReadCounts = new BarcodeToReadCounts();
                barcodeToReadCounts.setBarcode(string2);
                tObjectIntMap.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String string2, int n) {
                        barcodeToReadCounts.setCount(string2, n);
                        return true;
                    }
                });
                return barcodeToReadCounts;
            }
        };
    }

    @Override
    public void close() {
    }

    public List<Integer> getScoresForConstructBarcode(String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.barcodes.size());
        TObjectIntMap<String> tObjectIntMap = this.getScoresMapForConstructBarcode(string2);
        for (String string3 : this.barcodes) {
            arrayList.add(tObjectIntMap.get(string3));
        }
        return arrayList;
    }

    @Override
    public Integer getScore(String string2, String string3) {
        TObjectIntMap<String> tObjectIntMap = this.getScoresMapForConstructBarcode(string2);
        if (tObjectIntMap != null) {
            return tObjectIntMap.get(string3);
        }
        return null;
    }

    @Override
    public Map<String, Integer> getScoresBySampleForConstruct(String string2) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string3 : this.barcodes) {
            hashMap.put(string3, this.getScore(string2, string3));
        }
        return hashMap;
    }

    private TObjectIntMap<String> getScoresMapForConstructBarcode(String string2) {
        TObjectIntHashMap tObjectIntHashMap = (TObjectIntHashMap)this.barcodeToScoresMap.get(string2);
        if (tObjectIntHashMap == null) {
            tObjectIntHashMap = new TObjectIntHashMap();
            this.barcodeToScoresMap.put(string2, tObjectIntHashMap);
        }
        return tObjectIntHashMap;
    }
}

