/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.broadinstitute.rnai.poolq.impl.ReadOnlyIterator;
import org.broadinstitute.rnai.poolq.impl.SeqUtils;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;

abstract class AbstractReadsFileIterator
extends ReadOnlyIterator<String>
implements Closeable {
    private boolean alreadyParsedNextRead = false;
    private String nextRead = null;

    AbstractReadsFileIterator() {
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        if (!this.alreadyParsedNextRead) {
            this.parseNextRead();
        }
        boolean bl2 = bl = this.nextRead != null;
        if (!bl) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                throw new ReadsFileParserException.ReadsFileIOException(iOException);
            }
        }
        return bl;
    }

    @Override
    public String next() {
        if (!this.alreadyParsedNextRead) {
            this.parseNextRead();
        }
        if (this.nextRead == null) {
            throw new NoSuchElementException();
        }
        this.alreadyParsedNextRead = false;
        if (!this.isValidRead(this.nextRead)) {
            throw new ReadsFileParserException.NonACGTNReadException(this.nextRead);
        }
        return this.nextRead;
    }

    protected abstract String getNextRead() throws IOException;

    private void parseNextRead() {
        if (this.alreadyParsedNextRead) {
            throw new RuntimeException();
        }
        this.alreadyParsedNextRead = true;
        try {
            this.nextRead = this.getNextRead();
        }
        catch (IOException iOException) {
            throw new ReadsFileParserException.ReadsFileIOException(iOException);
        }
    }

    private boolean isValidRead(String string2) {
        return !string2.isEmpty() && SeqUtils.isDna(string2);
    }

    protected BufferedReader getBufferedReaderForInputStream(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return new BufferedReader(inputStreamReader);
    }
}

