/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.filewriter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.broadinstitute.rnai.poolq.api.PoolQScores;
import org.broadinstitute.rnai.poolq.impl.TextUtils;
import org.broadinstitute.rnai.poolq.impl.data.ScoreAggregator;
import org.broadinstitute.rnai.poolq.impl.filewriter.MatrixFileWriter;

public class ScoresFileWriter
extends MatrixFileWriter {
    private static final Pattern gctScoresFilenamePattern = Pattern.compile("^.*\\.gct$", 2);
    public static final String CONSTRUCT_SEQUENCE_COLUMN_HEADER = "Construct Barcode";
    public static final String CONSTRUCT_IDS_COLUMN_HEADER = "Construct IDs";
    public static final String GCT_VERSION_STRING = "#1.2";
    public static final String GCT_ROW_IDENTIFIER_COLUMN_HEADER = "NAME";
    public static final String GCT_EXTRA_COLUMN_HEADER = "Description";
    protected final boolean isGct;

    public ScoresFileWriter(boolean bl) {
        this.isGct = bl;
    }

    public static boolean isGctFile(String string2) {
        return gctScoresFilenamePattern.matcher(string2).matches();
    }

    @Override
    protected void printHeaders(PoolQScores poolQScores, PrintWriter printWriter) {
        if (this.isGct) {
            this.printGctPreamble(poolQScores, printWriter);
        }
        this.printConstructAndConstructIdColumns(printWriter);
        for (String string2 : poolQScores.getConditions()) {
            printWriter.append('\t').append(string2);
        }
        printWriter.append('\n');
    }

    protected void printConstructAndConstructIdColumns(PrintWriter printWriter) {
        if (this.isGct) {
            printWriter.append(GCT_ROW_IDENTIFIER_COLUMN_HEADER);
            printWriter.append('\t');
            printWriter.append(GCT_EXTRA_COLUMN_HEADER);
        } else {
            printWriter.append(CONSTRUCT_SEQUENCE_COLUMN_HEADER);
            printWriter.append('\t');
            printWriter.append(CONSTRUCT_IDS_COLUMN_HEADER);
        }
    }

    protected void printGctPreamble(PoolQScores poolQScores, PrintWriter printWriter) {
        printWriter.println(GCT_VERSION_STRING);
        printWriter.print(poolQScores.getConstructBarcodes().size());
        printWriter.print("\t");
        printWriter.print(poolQScores.getConditions().size());
        printWriter.println();
    }

    @Override
    protected void printBody(PoolQScores poolQScores, PrintWriter printWriter) {
        ScoreAggregator scoreAggregator = new ScoreAggregator(poolQScores.getConditionToBarcodeMap());
        for (String string2 : poolQScores.getConstructBarcodes()) {
            Collection<String> collection = poolQScores.getIdsForConstructBarcode(string2);
            this.printConstructAndConstructIds(printWriter, string2, collection);
            Map<String, Integer> map2 = poolQScores.getScoresBySampleForConstruct(string2);
            String string3 = TextUtils.join(scoreAggregator.getScoresListByCondition(map2, poolQScores.getConditions()), '\t');
            if (!string3.isEmpty()) {
                printWriter.append('\t');
                printWriter.append(string3);
            }
            printWriter.append('\n');
        }
    }

    protected void printConstructAndConstructIds(PrintWriter printWriter, String string2, Collection<String> collection) {
        printWriter.append(string2);
        printWriter.append('\t');
        printWriter.append(TextUtils.join(collection, ","));
    }
}

