/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;

class CycleFilesIterator
implements Iterator<File>,
Iterable<File> {
    private final File parentDir;
    private final int lane;
    private final int tile;
    private final String fileExt;
    protected final int[] cycles;
    protected int nextCycleIndex;

    public CycleFilesIterator(File file, int n, int n2, int[] nArray, String string2) {
        this.parentDir = file;
        this.lane = n;
        this.tile = n2;
        this.fileExt = string2;
        this.cycles = nArray;
        this.nextCycleIndex = 0;
    }

    CycleFilesIterator(CycleFilesIterator cycleFilesIterator, int[] nArray) {
        this(cycleFilesIterator.parentDir, cycleFilesIterator.lane, cycleFilesIterator.tile, nArray != null ? nArray : cycleFilesIterator.cycles, cycleFilesIterator.fileExt);
    }

    public void reset() {
        this.nextCycleIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextCycleIndex < this.cycles.length;
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.summarizeIterator());
        }
        File file = new File(this.parentDir, "C" + this.cycles[this.nextCycleIndex] + ".1");
        File file2 = new File(file, "s_" + this.lane + "_" + this.tile + this.fileExt);
        ++this.nextCycleIndex;
        return file2;
    }

    public int getNextCycle() {
        return this.cycles[this.nextCycleIndex];
    }

    private String summarizeIterator() {
        String string2 = "";
        if (this.cycles.length > 0) {
            string2 = String.valueOf(this.cycles[0]);
            for (int i = 1; i < this.cycles.length; ++i) {
                string2 = string2 + ", " + String.valueOf(this.cycles[i]);
            }
        }
        return " Parent dir (" + this.parentDir.getAbsolutePath() + ")" + " Lane (" + this.lane + ") Tile (" + this.tile + ") FileExt(" + this.fileExt + ")" + " CycleIndex (" + this.nextCycleIndex + ")" + "Cycles(" + string2 + ")";
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + CycleFilesIterator.class.getName());
    }

    @Override
    public Iterator<File> iterator() {
        return this;
    }
}

