/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;

class IlluminaFileMap
extends TreeMap<Integer, File> {
    public IlluminaFileMap() {
    }

    public IlluminaFileMap(List<Integer> list, List<File> list2) {
        if (list.size() != list2.size()) {
            throw new PicardException("Tiles and Files were not of the same length: Tiles(" + list.size() + ") Files(" + list2.size() + ") ");
        }
        for (int i = 0; i < list.size(); ++i) {
            this.put(list.get(i), list2.get(i));
        }
    }

    public IlluminaFileMap keep(List<Integer> list) {
        IlluminaFileMap illuminaFileMap = new IlluminaFileMap();
        for (Integer n : list) {
            File file = (File)this.get(n);
            if (file == null) continue;
            illuminaFileMap.put(n, file);
        }
        return illuminaFileMap;
    }

    public List<File> getFilesStartingAt(int n) {
        return new ArrayList<File>(this.tailMap(n).values());
    }
}

