/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BaseData;
import net.sf.picard.illumina.parser.PfData;
import net.sf.picard.illumina.parser.PositionalData;
import net.sf.picard.illumina.parser.QualityData;

class QseqReadData
implements PositionalData,
BaseData,
QualityData,
PfData {
    private final byte[][] bases;
    private final byte[][] qualities;
    private Boolean pf;
    private Integer xCoord;
    private Integer yCoord;
    private Integer lane;
    private Integer tile;

    public QseqReadData(int[] nArray) {
        this.bases = new byte[nArray.length][];
        this.qualities = new byte[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            this.bases[i] = new byte[nArray[i]];
            this.qualities[i] = new byte[nArray[i]];
        }
        this.pf = null;
        this.xCoord = null;
        this.yCoord = null;
        this.lane = null;
        this.tile = null;
    }

    @Override
    public byte[][] getBases() {
        return this.bases;
    }

    @Override
    public byte[][] getQualities() {
        return this.qualities;
    }

    public void setOrCheckPf(boolean bl) {
        if (this.pf == null) {
            this.pf = bl;
        } else {
            this.assertEquals(this.pf, bl, "pf");
        }
    }

    @Override
    public boolean isPf() {
        return this.pf;
    }

    @Override
    public int getXCoordinate() {
        return this.xCoord;
    }

    public void setOrCheckXCoordinate(int n) {
        if (this.xCoord == null) {
            this.xCoord = n;
        } else {
            this.assertEquals(this.xCoord, n, "xCoord");
        }
    }

    @Override
    public int getYCoordinate() {
        return this.yCoord;
    }

    public void setOrCheckYCoordinate(int n) {
        if (this.yCoord == null) {
            this.yCoord = n;
        } else {
            this.assertEquals(this.yCoord, n, "yCoord");
        }
    }

    public int getLane() {
        return this.lane;
    }

    public void setOrCheckLane(int n) {
        if (this.lane == null) {
            this.lane = n;
        } else {
            this.assertEquals(this.lane, n, "lane");
        }
    }

    public int getTile() {
        return this.tile;
    }

    public void setOrCheckTile(int n) {
        if (this.tile == null) {
            this.tile = n;
        } else {
            this.assertEquals(this.tile, n, "tile");
        }
    }

    public <T> void assertEquals(T t, T t2, String string2) {
        if (!t.equals(t2)) {
            throw new PicardException(string2 + " values don't match: original(" + t + ") new(" + t2 + ")");
        }
    }
}

