/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import net.sf.picard.reference.FastaSequenceFile;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFile;

public class ReferenceSequenceFileFactory {
    public static final Set<String> FASTA_EXTENSIONS = new HashSet<String>(){
        {
            this.add(".fasta");
            this.add(".fasta.gz");
            this.add(".fa");
            this.add(".fa.gz");
            this.add(".txt");
            this.add(".txt.gz");
        }
    };

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean bl) {
        String string2 = file.getName();
        for (String string3 : FASTA_EXTENSIONS) {
            if (!string2.endsWith(string3)) continue;
            if (bl && IndexedFastaSequenceFile.canCreateIndexedFastaReader(file)) {
                try {
                    return new IndexedFastaSequenceFile(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IllegalStateException("Should never happen, because existence of files has been checked.", fileNotFoundException);
                }
            }
            return new FastaSequenceFile(file, bl);
        }
        throw new IllegalArgumentException("File is not a supported reference file type: " + file.getAbsolutePath());
    }
}

