/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.fastq.FastqReader;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.util.FastqQualityFormat;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.util.QualityEncodingDetector;
import net.sf.picard.util.SolexaQualityConverter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.StringUtil;

public class FastqToSam
extends CommandLineProgram {
    private static final Log LOG = Log.getInstance(FastqToSam.class);
    @Usage
    public String USAGE = "Extracts read sequences and qualities from the input fastq file and writes them into the output file in unaligned BAM format. Input files can be in GZip format (end in .gz).\n";
    @Option(shortName="F1", doc="Input fastq file (optionally gzipped) for single end data, or first read in paired end data.")
    public File FASTQ;
    @Option(shortName="F2", doc="Input fastq file (optionally gzipped) for the second read of paired end data.", optional=true)
    public File FASTQ2;
    @Option(shortName="V", doc="A value describing how the quality values are encoded in the fastq.  Either Solexa for pre-pipeline 1.3 style scores (solexa scaling + 66), Illumina for pipeline 1.3 and above (phred scaling + 64) or Standard for phred scaled scores with a character shift of 33.  If this value is not specified, the quality format will be detected automatically.", optional=true)
    public FastqQualityFormat QUALITY_FORMAT;
    @Option(doc="Output SAM/BAM file. ", shortName="O")
    public File OUTPUT;
    @Option(shortName="RG", doc="Read group name")
    public String READ_GROUP_NAME = "A";
    @Option(shortName="SM", doc="Sample name to insert into the read group header")
    public String SAMPLE_NAME;
    @Option(shortName="LB", doc="The library name to place into the LB attribute in the read group header", optional=true)
    public String LIBRARY_NAME;
    @Option(shortName="PU", doc="The platform unit (often run_barcode.lane) to insert into the read group header", optional=true)
    public String PLATFORM_UNIT;
    @Option(shortName="PL", doc="The platform type (e.g. illumina, solid) to insert into the read group header", optional=true)
    public String PLATFORM;
    @Option(shortName="CN", doc="The sequencing center from which the data originated", optional=true)
    public String SEQUENCING_CENTER;
    @Option(shortName="PI", doc="Predicted median insert size, to insert into the read group header", optional=true)
    public Integer PREDICTED_INSERT_SIZE;
    @Option(doc="Comment(s) to include in the merged output file's header.", optional=true, shortName="CO")
    public List<String> COMMENT = new ArrayList<String>();
    @Option(shortName="DS", doc="Inserted into the read group header", optional=true)
    public String DESCRIPTION;
    @Option(shortName="DT", doc="Date the run was produced, to insert into the read group header", optional=true)
    public Iso8601Date RUN_DATE;
    @Option(shortName="SO", doc="The sort order for the output sam/bam file.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(doc="Minimum quality allowed in the input fastq.  An exception will be thrown if a quality is less than this value.")
    public int MIN_Q = 0;
    @Option(doc="Maximum quality allowed in the input fastq.  An exception will be thrown if a quality is greater than this value.")
    public int MAX_Q = 93;
    @Option(doc="If true and this is an unpaired fastq any occurance of '/1' will be removed from the end of a read name.")
    public Boolean STRIP_UNPAIRED_MATE_NUMBER = false;
    private static final SolexaQualityConverter solexaQualityConverter = SolexaQualityConverter.getSingleton();

    public static void main(String[] stringArray) {
        System.exit(new FastqToSam().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        if (this.QUALITY_FORMAT == null) {
            QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
            FastqReader fastqReader = new FastqReader(this.FASTQ);
            if (this.FASTQ2 == null) {
                qualityEncodingDetector.add(10000L, fastqReader);
            } else {
                FastqReader fastqReader2 = new FastqReader(this.FASTQ2);
                qualityEncodingDetector.add(10000L, fastqReader, fastqReader2);
                fastqReader2.close();
            }
            fastqReader.close();
            this.QUALITY_FORMAT = qualityEncodingDetector.generateBestGuess(QualityEncodingDetector.FileContext.FASTQ);
            if (qualityEncodingDetector.isDeterminationAmbiguous()) {
                LOG.warn("Making ambiguous determination about fastq's quality encoding; more than one format possible based on observed qualities.");
            }
            LOG.info(String.format("Auto-detected quality format as: %s.", new Object[]{this.QUALITY_FORMAT}));
        }
        int n = this.FASTQ2 == null ? this.doUnpaired() : this.doPaired();
        LOG.info("Processed " + n + " fastq reads");
        return 0;
    }

    protected int doUnpaired() {
        IoUtil.assertFileIsReadable(this.FASTQ);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        FastqReader fastqReader = new FastqReader(this.FASTQ);
        SAMFileHeader sAMFileHeader = this.createFileHeader();
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, false, this.OUTPUT);
        int n = 0;
        ProgressLogger progressLogger = new ProgressLogger(LOG);
        while (fastqReader.hasNext()) {
            FastqRecord fastqRecord = fastqReader.next();
            SAMRecord sAMRecord = this.createSamRecord(sAMFileHeader, this.getReadName(fastqRecord.getReadHeader(), false), fastqRecord, false);
            sAMRecord.setReadPairedFlag(false);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
            ++n;
        }
        sAMFileWriter.close();
        return n;
    }

    protected int doPaired() {
        IoUtil.assertFileIsReadable(this.FASTQ);
        IoUtil.assertFileIsReadable(this.FASTQ2);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        FastqReader fastqReader = new FastqReader(this.FASTQ);
        FastqReader fastqReader2 = new FastqReader(this.FASTQ2);
        SAMFileHeader sAMFileHeader = this.createFileHeader();
        SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileHeader, false, this.OUTPUT);
        int n = 0;
        ProgressLogger progressLogger = new ProgressLogger(LOG);
        while (fastqReader.hasNext() && fastqReader2.hasNext()) {
            FastqRecord fastqRecord = fastqReader.next();
            FastqRecord fastqRecord2 = fastqReader2.next();
            String string2 = this.getReadName(fastqRecord.getReadHeader(), true);
            String string3 = this.getReadName(fastqRecord2.getReadHeader(), true);
            String string4 = this.getBaseName(string2, string3, fastqReader, fastqReader2);
            SAMRecord sAMRecord = this.createSamRecord(sAMFileHeader, string4, fastqRecord, true);
            sAMRecord.setFirstOfPairFlag(true);
            sAMRecord.setSecondOfPairFlag(false);
            sAMFileWriter.addAlignment(sAMRecord);
            progressLogger.record(sAMRecord);
            SAMRecord sAMRecord2 = this.createSamRecord(sAMFileHeader, string4, fastqRecord2, true);
            sAMRecord2.setFirstOfPairFlag(false);
            sAMRecord2.setSecondOfPairFlag(true);
            sAMFileWriter.addAlignment(sAMRecord2);
            progressLogger.record(sAMRecord2);
            ++n;
        }
        sAMFileWriter.close();
        if (fastqReader.hasNext() || fastqReader2.hasNext()) {
            throw new PicardException("Input paired fastq files must be the same length");
        }
        return n;
    }

    private SAMRecord createSamRecord(SAMFileHeader sAMFileHeader, String string2, FastqRecord fastqRecord, boolean bl) {
        SAMRecord sAMRecord = new SAMRecord(sAMFileHeader);
        sAMRecord.setReadName(string2);
        sAMRecord.setReadString(fastqRecord.getReadString());
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)this.READ_GROUP_NAME);
        byte[] byArray = StringUtil.stringToBytes(fastqRecord.getBaseQualityString());
        this.convertQuality(byArray, this.QUALITY_FORMAT);
        for (byte by2 : byArray) {
            int n = by2 & 0xFF;
            if (n >= this.MIN_Q && n <= this.MAX_Q) continue;
            throw new PicardException("Base quality " + n + " is not in the range " + this.MIN_Q + ".." + this.MAX_Q + " for read " + fastqRecord.getReadHeader());
        }
        sAMRecord.setBaseQualities(byArray);
        if (bl) {
            sAMRecord.setReadPairedFlag(true);
            sAMRecord.setMateUnmappedFlag(true);
        }
        return sAMRecord;
    }

    private SAMFileHeader createFileHeader() {
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(this.READ_GROUP_NAME);
        sAMReadGroupRecord.setSample(this.SAMPLE_NAME);
        if (this.LIBRARY_NAME != null) {
            sAMReadGroupRecord.setLibrary(this.LIBRARY_NAME);
        }
        if (this.PLATFORM != null) {
            sAMReadGroupRecord.setPlatform(this.PLATFORM);
        }
        if (this.PLATFORM_UNIT != null) {
            sAMReadGroupRecord.setPlatformUnit(this.PLATFORM_UNIT);
        }
        if (this.SEQUENCING_CENTER != null) {
            sAMReadGroupRecord.setSequencingCenter(this.SEQUENCING_CENTER);
        }
        if (this.PREDICTED_INSERT_SIZE != null) {
            sAMReadGroupRecord.setPredictedMedianInsertSize(this.PREDICTED_INSERT_SIZE);
        }
        if (this.DESCRIPTION != null) {
            sAMReadGroupRecord.setDescription(this.DESCRIPTION);
        }
        if (this.RUN_DATE != null) {
            sAMReadGroupRecord.setRunDate(this.RUN_DATE);
        }
        SAMFileHeader sAMFileHeader = new SAMFileHeader();
        sAMFileHeader.addReadGroup(sAMReadGroupRecord);
        for (String string2 : this.COMMENT) {
            sAMFileHeader.addComment(string2);
        }
        sAMFileHeader.setSortOrder(this.SORT_ORDER);
        return sAMFileHeader;
    }

    void convertQuality(byte[] byArray, FastqQualityFormat fastqQualityFormat) {
        switch (fastqQualityFormat) {
            case Standard: {
                SAMUtils.fastqToPhred(byArray);
                break;
            }
            case Solexa: {
                solexaQualityConverter.convertSolexaQualityCharsToPhredBinary(byArray);
                break;
            }
            case Illumina: {
                solexaQualityConverter.convertSolexa_1_3_QualityCharsToPhredBinary(byArray);
            }
        }
    }

    String getBaseName(String string2, String string3, FastqReader fastqReader, FastqReader fastqReader2) {
        String[] stringArray = this.getReadNameTokens(string2, 1, fastqReader);
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        stringArray = this.getReadNameTokens(string3, 2, fastqReader2);
        String string6 = stringArray[0];
        String string7 = stringArray[1];
        if (!string4.equals(string6)) {
            throw new PicardException(String.format("In paired mode, read name 1 (%s) does not match read name 2 (%s)", string4, string6));
        }
        boolean bl = StringUtil.isBlank(string5);
        boolean bl2 = StringUtil.isBlank(string7);
        if (bl || bl2) {
            if (!bl) {
                throw new PicardException(this.error(fastqReader, "Pair 1 number is missing (" + string2 + "). Both pair numbers must be present or neither."));
            }
            if (!bl2) {
                throw new PicardException(this.error(fastqReader2, "Pair 2 number is missing (" + string3 + "). Both pair numbers must be present or neither."));
            }
        } else {
            if (!string5.equals("1")) {
                throw new PicardException(this.error(fastqReader, "Pair 1 number must be 1 (" + string2 + ")"));
            }
            if (!string7.equals("2")) {
                throw new PicardException(this.error(fastqReader2, "Pair 2 number must be 2 (" + string3 + ")"));
            }
        }
        return string4;
    }

    private String[] getReadNameTokens(String string2, int n, FastqReader fastqReader) {
        if (string2.equals("")) {
            throw new PicardException(this.error(fastqReader, "Pair read name " + n + " cannot be empty: " + string2));
        }
        int n2 = string2.lastIndexOf("/");
        String[] stringArray = new String[2];
        if (n2 == -1) {
            stringArray[0] = string2;
            stringArray[1] = null;
        } else {
            stringArray[1] = string2.substring(n2 + 1, string2.length());
            if (!stringArray[1].equals("1") && !stringArray[1].equals("2")) {
                stringArray[0] = string2;
                stringArray[1] = null;
            } else {
                stringArray[0] = string2.substring(0, n2);
            }
        }
        return stringArray;
    }

    private String error(FastqReader fastqReader, String string2) {
        return string2 + " at line " + fastqReader.getLineNumber() + " in file " + fastqReader.getFile().getAbsolutePath();
    }

    private String getReadName(String string2, boolean bl) {
        String string3;
        int n = string2.indexOf(" ");
        String string4 = string3 = n == -1 ? string2 : string2.substring(0, n);
        while (this.STRIP_UNPAIRED_MATE_NUMBER.booleanValue() && !bl && string3.endsWith("/1")) {
            string3 = string3.substring(0, string3.length() - 2);
        }
        return string3;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MIN_Q < 0) {
            return new String[]{"MIN_Q must be >= 0"};
        }
        if (this.MAX_Q > 93) {
            return new String[]{"MAX_Q must be <= 93"};
        }
        return null;
    }
}

