/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalTree;

public class OverlapDetector<T> {
    private Map<Object, IntervalTree<Set<T>>> cache = new HashMap<Object, IntervalTree<Set<T>>>();
    private final int lhsBuffer;
    private final int rhsBuffer;

    public OverlapDetector(int n, int n2) {
        this.lhsBuffer = n;
        this.rhsBuffer = n2;
    }

    public void addLhs(T t, Interval interval) {
        Set set;
        String string2 = interval.getSequence();
        IntervalTree<Set<Object>> intervalTree = this.cache.get(string2);
        if (intervalTree == null) {
            intervalTree = new IntervalTree();
            this.cache.put(string2, intervalTree);
        }
        int n = interval.getStart() + this.lhsBuffer;
        int n2 = interval.getEnd() - this.lhsBuffer;
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.add(t);
        if (n <= n2 && (set = (Set)intervalTree.put(n, n2, hashSet)) != null) {
            set.add(t);
            intervalTree.put(n, n2, set);
        }
    }

    public void addAll(List<T> list, List<Interval> list2) {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Objects and intervals must be the same size.");
        }
        for (int i = 0; i < list.size(); ++i) {
            this.addLhs(list.get(i), list2.get(i));
        }
    }

    public Collection<T> getOverlaps(Interval interval) {
        ArrayList arrayList = new ArrayList();
        String string2 = interval.getSequence();
        IntervalTree<Set<T>> intervalTree = this.cache.get(string2);
        int n = interval.getStart() + this.rhsBuffer;
        int n2 = interval.getEnd() - this.rhsBuffer;
        if (intervalTree != null && n <= n2) {
            Iterator<IntervalTree.Node<Set<T>>> iterator2 = intervalTree.overlappers(n, n2);
            while (iterator2.hasNext()) {
                IntervalTree.Node<Set<T>> node = iterator2.next();
                arrayList.addAll(node.getValue());
            }
        }
        return arrayList;
    }

    public Collection<T> getAll() {
        HashSet hashSet = new HashSet();
        for (IntervalTree<Set<T>> intervalTree : this.cache.values()) {
            for (IntervalTree.Node<Set<T>> node : intervalTree) {
                hashSet.addAll(node.getValue());
            }
        }
        return hashSet;
    }
}

