/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMSequenceRecord;

public class SAMSequenceDictionary {
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String string2) {
        return this.mSequenceMap.get(string2);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int n = 0;
        for (SAMSequenceRecord sAMSequenceRecord : list) {
            sAMSequenceRecord.setSequenceIndex(n++);
            if (this.mSequenceMap.put(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sAMSequenceRecord.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sAMSequenceRecord) {
        if (this.mSequenceMap.containsKey(sAMSequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sAMSequenceRecord.getSequenceName());
        }
        sAMSequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sAMSequenceRecord);
        this.mSequenceMap.put(sAMSequenceRecord.getSequenceName(), sAMSequenceRecord);
    }

    public SAMSequenceRecord getSequence(int n) {
        if (n < 0 || n >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(n);
    }

    public int getSequenceIndex(String string2) {
        SAMSequenceRecord sAMSequenceRecord = this.mSequenceMap.get(string2);
        if (sAMSequenceRecord == null) {
            return -1;
        }
        return sAMSequenceRecord.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public long getReferenceLength() {
        long l = 0L;
        for (SAMSequenceRecord sAMSequenceRecord : this.getSequences()) {
            l += (long)sAMSequenceRecord.getSequenceLength();
        }
        return l;
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SAMSequenceDictionary sAMSequenceDictionary = (SAMSequenceDictionary)object;
        return this.mSequences.equals(sAMSequenceDictionary.mSequences);
    }

    public int hashCode() {
        return this.mSequences.hashCode();
    }
}

