/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.tribble.index.interval.Interval;

public class IntervalTree {
    Node root;
    Node NIL;
    int size;

    public IntervalTree() {
        this.root = this.NIL = Node.NIL;
        this.size = 0;
    }

    public void insert(Interval interval) {
        Node node = new Node(interval);
        this.insert(node);
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public List<Interval> findOverlapping(Interval interval) {
        if (this.root().isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        this.searchAll(interval, this.root(), arrayList);
        return arrayList;
    }

    public String toString() {
        return this.root().toString();
    }

    private List<Interval> searchAll(Interval interval, Node node, List<Interval> list) {
        if (node.interval.overlaps(interval)) {
            list.add(node.interval);
        }
        if (!node.left.isNull() && node.left.max >= interval.start) {
            this.searchAll(interval, node.left, list);
        }
        if (!node.right.isNull() && node.right.min <= interval.end) {
            this.searchAll(interval, node.right, list);
        }
        return list;
    }

    public List<Interval> getIntervals() {
        if (this.root().isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Interval> arrayList = new ArrayList<Interval>(this.size);
        this.getAll(this.root(), arrayList);
        return arrayList;
    }

    private List<Interval> getAll(Node node, List<Interval> list) {
        list.add(node.interval);
        if (!node.left.isNull()) {
            this.getAll(node.left, list);
        }
        if (!node.right.isNull()) {
            this.getAll(node.right, list);
        }
        return list;
    }

    private int getRealMax(Node node) {
        if (node.isNull()) {
            return Integer.MIN_VALUE;
        }
        int n = this.getRealMax(node.left);
        int n2 = this.getRealMax(node.right);
        int n3 = node.interval.end;
        int n4 = n > n2 ? n : n2;
        return n4 > n3 ? n4 : n3;
    }

    private int getRealMin(Node node) {
        if (node.isNull()) {
            return Integer.MAX_VALUE;
        }
        int n = this.getRealMin(node.left);
        int n2 = this.getRealMin(node.right);
        int n3 = node.interval.start;
        int n4 = n < n2 ? n : n2;
        return n4 < n3 ? n4 : n3;
    }

    private void insert(Node node) {
        assert (node != null);
        assert (!node.isNull());
        this.treeInsert(node);
        node.color = Node.RED;
        while (node != this.root && node.parent.color == Node.RED) {
            Node node2;
            if (node.parent == node.parent.parent.left) {
                node2 = node.parent.parent.right;
                if (node2.color == Node.RED) {
                    node.parent.color = Node.BLACK;
                    node2.color = Node.BLACK;
                    node.parent.parent.color = Node.RED;
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.leftRotate(node);
                }
                node.parent.color = Node.BLACK;
                node.parent.parent.color = Node.RED;
                this.rightRotate(node.parent.parent);
                continue;
            }
            node2 = node.parent.parent.left;
            if (node2.color == Node.RED) {
                node.parent.color = Node.BLACK;
                node2.color = Node.BLACK;
                node.parent.parent.color = Node.RED;
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rightRotate(node);
            }
            node.parent.color = Node.BLACK;
            node.parent.parent.color = Node.RED;
            this.leftRotate(node.parent.parent);
        }
        this.root.color = Node.BLACK;
    }

    private Node root() {
        return this.root;
    }

    private void leftRotate(Node node) {
        Node node2 = node.right;
        node.right = node2.left;
        if (node2.left != this.NIL) {
            node2.left.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent == this.NIL) {
            this.root = node2;
        } else if (node.parent.left == node) {
            node.parent.left = node2;
        } else {
            node.parent.right = node2;
        }
        node2.left = node;
        node.parent = node2;
        this.applyUpdate(node);
    }

    private void rightRotate(Node node) {
        Node node2 = node.left;
        node.left = node2.right;
        if (node2.right != this.NIL) {
            node2.right.parent = node;
        }
        node2.parent = node.parent;
        if (node.parent == this.NIL) {
            this.root = node2;
        } else if (node.parent.right == node) {
            node.parent.right = node2;
        } else {
            node.parent.left = node2;
        }
        node2.right = node;
        node.parent = node2;
        this.applyUpdate(node);
    }

    private void treeInsert(Node node) {
        Node node2 = this.root;
        Node node3 = this.NIL;
        while (node2 != this.NIL) {
            node3 = node2;
            if (node.interval.start <= node2.interval.start) {
                node2 = node2.left;
                continue;
            }
            node2 = node2.right;
        }
        node.parent = node3;
        if (node3 == this.NIL) {
            this.root = node;
            node.left = node.right = this.NIL;
        } else if (node.interval.start <= node3.interval.start) {
            node3.left = node;
        } else {
            node3.right = node;
        }
        this.applyUpdate(node);
    }

    private void applyUpdate(Node node) {
        while (!node.isNull()) {
            this.update(node);
            node = node.parent;
        }
    }

    private void update(Node node) {
        node.max = Math.max(Math.max(node.left.max, node.right.max), node.interval.end);
        node.min = Math.min(Math.min(node.left.min, node.right.min), node.interval.start);
    }

    public int size() {
        return this._size(this.root);
    }

    private int _size(Node node) {
        if (node.isNull()) {
            return 0;
        }
        return 1 + this._size(node.left) + this._size(node.right);
    }

    private boolean allRedNodesFollowConstraints(Node node) {
        if (node.isNull()) {
            return true;
        }
        if (node.color == Node.BLACK) {
            return this.allRedNodesFollowConstraints(node.left) && this.allRedNodesFollowConstraints(node.right);
        }
        return node.left.color == Node.BLACK && node.right.color == Node.BLACK && this.allRedNodesFollowConstraints(node.left) && this.allRedNodesFollowConstraints(node.right);
    }

    private boolean isBalancedBlackHeight(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.blackHeight(node.left) == this.blackHeight(node.right) && this.isBalancedBlackHeight(node.left) && this.isBalancedBlackHeight(node.right);
    }

    private int blackHeight(Node node) {
        if (node.isNull()) {
            return 0;
        }
        int n = this.blackHeight(node.left);
        if (node.color == Node.BLACK) {
            return n + 1;
        }
        return n;
    }

    public boolean isValid() {
        if (this.root.color != Node.BLACK) {
            return false;
        }
        if (this.NIL.color != Node.BLACK) {
            return false;
        }
        if (!this.allRedNodesFollowConstraints(this.root)) {
            return false;
        }
        if (!this.isBalancedBlackHeight(this.root)) {
            return false;
        }
        return this.hasCorrectMaxFields(this.root) && this.hasCorrectMinFields(this.root);
    }

    private boolean hasCorrectMaxFields(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.getRealMax(node) == node.max && this.hasCorrectMaxFields(node.left) && this.hasCorrectMaxFields(node.right);
    }

    private boolean hasCorrectMinFields(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.getRealMin(node) == node.min && this.hasCorrectMinFields(node.left) && this.hasCorrectMinFields(node.right);
    }

    static class Node {
        public static boolean BLACK = false;
        public static boolean RED = true;
        Interval interval;
        int min;
        int max = Integer.MIN_VALUE;
        Node left;
        Node right;
        boolean color;
        Node parent;
        static Node NIL = new Node();

        private Node() {
            this.min = Integer.MAX_VALUE;
        }

        public void store(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.interval.start);
            dataOutputStream.writeInt(this.interval.end);
            dataOutputStream.writeInt(this.min);
            dataOutputStream.writeInt(this.max);
        }

        public Node(Interval interval) {
            this();
            this.parent = NIL;
            this.left = NIL;
            this.right = NIL;
            this.interval = interval;
            this.color = RED;
        }

        public boolean isNull() {
            return this == NIL;
        }

        public String toString() {
            LinkedHashMap<Interval, Integer> linkedHashMap = new LinkedHashMap<Interval, Integer>();
            if (this == NIL) {
                return "nil";
            }
            StringBuffer stringBuffer = new StringBuffer();
            this._toString(stringBuffer, linkedHashMap);
            stringBuffer.append("\n");
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                stringBuffer.append(entry.getValue() + " = " + entry.getKey());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public void _toString(StringBuffer stringBuffer, Map<Interval, Integer> map2) {
            Integer n;
            Integer n2;
            if (this == NIL) {
                stringBuffer.append("nil");
                stringBuffer.append("\n");
                return;
            }
            Integer n3 = map2.get(this.interval);
            if (n3 == null) {
                n3 = map2.size();
                map2.put(this.interval, n3);
            }
            if ((n2 = map2.get(this.left.interval)) == null) {
                n2 = map2.size();
                map2.put(this.left.interval, n2);
            }
            if ((n = map2.get(this.right.interval)) == null) {
                n = map2.size();
                map2.put(this.right.interval, n);
            }
            stringBuffer.append(n3 + " -> " + n2 + " , " + n);
            stringBuffer.append("\n");
            this.left._toString(stringBuffer, map2);
            this.right._toString(stringBuffer, map2);
        }

        static {
            Node.NIL.color = BLACK;
            Node.NIL.parent = NIL;
            Node.NIL.left = NIL;
            Node.NIL.right = NIL;
        }
    }
}

