/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.rnai.poolq.impl.fileparser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.Validate;
import org.broadinstitute.rnai.poolq.api.ReadsFileType;
import org.broadinstitute.rnai.poolq.impl.ReadOnlyIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.FastQIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileInfo;
import org.broadinstitute.rnai.poolq.impl.fileparser.ReadsFileParserException;
import org.broadinstitute.rnai.poolq.impl.fileparser.SamReadsFileIterator;
import org.broadinstitute.rnai.poolq.impl.fileparser.TextReadsFileIterator;

public class ReadsFileIteratorFactory {
    private ReadsFileIteratorFactory() {
    }

    public static Iterator<String> readsFileIteratorFor(String string2, ReadsFileType readsFileType, Boolean bl) {
        ReadsFileInfo readsFileInfo = ReadsFileInfo.forName(Validate.notNull(string2, "reads file name may not be null", new Object[0]));
        InputStream inputStream = ReadsFileIteratorFactory.inputStreamFor(string2, readsFileInfo);
        ReadsFileType readsFileType2 = readsFileType == ReadsFileType.AUTO ? readsFileInfo.getReadsFileType() : readsFileType;
        switch (readsFileType2) {
            case FASTQ: {
                return ReadsFileIteratorFactory.fastqIteratorFor(inputStream);
            }
            case SAM: 
            case BAM: {
                return ReadsFileIteratorFactory.samIteratorFor(inputStream, bl);
            }
            case RAW: {
                return ReadsFileIteratorFactory.rawIteratorFor(inputStream);
            }
        }
        throw new ReadsFileParserException("Unable to recognize file type for " + string2);
    }

    public static InputStream inputStreamFor(String string2, ReadsFileInfo readsFileInfo) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            if (readsFileInfo.isGzFile()) {
                return new GZIPInputStream(new BufferedInputStream(fileInputStream));
            }
            return fileInputStream;
        }
        catch (IOException iOException) {
            throw new ReadsFileParserException.ReadsFileIOException(iOException);
        }
    }

    public static Iterator<String> samIteratorFor(InputStream inputStream, Boolean bl) {
        return new SamReadsFileIterator(Validate.notNull(inputStream, "input stream may not be null", new Object[0]), bl);
    }

    public static Iterator<String> fastqIteratorFor(final InputStream inputStream) {
        return new ReadOnlyIterator<String>(){
            final FastQIterator iter;
            {
                this.iter = new FastQIterator(Validate.notNull(inputStream, "input stream may not be null", new Object[0]));
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                return this.iter.next().seq();
            }
        };
    }

    public static Iterator<String> rawIteratorFor(InputStream inputStream) {
        return new TextReadsFileIterator(Validate.notNull(inputStream, "input stream may not be null", new Object[0]));
    }
}

