/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.variant.variantcontext.writer.BCF2Encoder;
import org.broadinstitute.variant.variantcontext.writer.BCF2FieldEncoder;
import org.broadinstitute.variant.variantcontext.writer.BCF2FieldWriter;
import org.broadinstitute.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

public class BCF2FieldWriterManager {
    final Map<String, BCF2FieldWriter.SiteWriter> siteWriters = new HashMap<String, BCF2FieldWriter.SiteWriter>();
    final Map<String, BCF2FieldWriter.GenotypesWriter> genotypesWriters = new HashMap<String, BCF2FieldWriter.GenotypesWriter>();
    final IntGenotypeFieldAccessors intGenotypeFieldAccessors = new IntGenotypeFieldAccessors();

    public void setup(VCFHeader vCFHeader, BCF2Encoder bCF2Encoder, Map<String, Integer> map2) {
        BCF2FieldWriter bCF2FieldWriter;
        String string2;
        for (VCFInfoHeaderLine vCFCompoundHeaderLine : vCFHeader.getInfoHeaderLines()) {
            string2 = vCFCompoundHeaderLine.getID();
            bCF2FieldWriter = this.createInfoWriter(vCFHeader, vCFCompoundHeaderLine, bCF2Encoder, map2);
            this.add(this.siteWriters, string2, bCF2FieldWriter);
        }
        for (VCFFormatHeaderLine vCFFormatHeaderLine : vCFHeader.getFormatHeaderLines()) {
            string2 = vCFFormatHeaderLine.getID();
            bCF2FieldWriter = this.createGenotypesWriter(vCFHeader, vCFFormatHeaderLine, bCF2Encoder, map2);
            this.add(this.genotypesWriters, string2, bCF2FieldWriter);
        }
    }

    @Requires(value={"field != null", "writer != null"})
    @Ensures(value={"map.containsKey(field)"})
    private final <T> void add(Map<String, T> map2, String string2, T t) {
        if (map2.containsKey(string2)) {
            throw new IllegalStateException("BUG: field " + string2 + " already seen in VCFHeader while building BCF2 field encoders");
        }
        map2.put(string2, t);
    }

    private BCF2FieldWriter.SiteWriter createInfoWriter(VCFHeader vCFHeader, VCFInfoHeaderLine vCFInfoHeaderLine, BCF2Encoder bCF2Encoder, Map<String, Integer> map2) {
        return new BCF2FieldWriter.GenericSiteWriter(vCFHeader, this.createFieldEncoder(vCFInfoHeaderLine, bCF2Encoder, map2, false));
    }

    private BCF2FieldEncoder createFieldEncoder(VCFCompoundHeaderLine vCFCompoundHeaderLine, BCF2Encoder bCF2Encoder, Map<String, Integer> map2, boolean bl) {
        if (bl && this.intGenotypeFieldAccessors.getAccessor(vCFCompoundHeaderLine.getID()) != null) {
            return new BCF2FieldEncoder.IntArray(vCFCompoundHeaderLine, map2);
        }
        if (bl && vCFCompoundHeaderLine.getID().equals("GT")) {
            return new BCF2FieldEncoder.GenericInts(vCFCompoundHeaderLine, map2);
        }
        switch (vCFCompoundHeaderLine.getType()) {
            case Character: 
            case String: {
                return new BCF2FieldEncoder.StringOrCharacter(vCFCompoundHeaderLine, map2);
            }
            case Flag: {
                return new BCF2FieldEncoder.Flag(vCFCompoundHeaderLine, map2);
            }
            case Float: {
                return new BCF2FieldEncoder.Float(vCFCompoundHeaderLine, map2);
            }
            case Integer: {
                if (vCFCompoundHeaderLine.isFixedCount() && vCFCompoundHeaderLine.getCount() == 1) {
                    return new BCF2FieldEncoder.AtomicInt(vCFCompoundHeaderLine, map2);
                }
                return new BCF2FieldEncoder.GenericInts(vCFCompoundHeaderLine, map2);
            }
        }
        throw new IllegalArgumentException("Unexpected type for field " + vCFCompoundHeaderLine.getID());
    }

    private BCF2FieldWriter.GenotypesWriter createGenotypesWriter(VCFHeader vCFHeader, VCFFormatHeaderLine vCFFormatHeaderLine, BCF2Encoder bCF2Encoder, Map<String, Integer> map2) {
        String string2 = vCFFormatHeaderLine.getID();
        BCF2FieldEncoder bCF2FieldEncoder = this.createFieldEncoder(vCFFormatHeaderLine, bCF2Encoder, map2, true);
        if (string2.equals("GT")) {
            return new BCF2FieldWriter.GTWriter(vCFHeader, bCF2FieldEncoder);
        }
        if (vCFFormatHeaderLine.getID().equals("FT")) {
            return new BCF2FieldWriter.FTGenotypesWriter(vCFHeader, bCF2FieldEncoder);
        }
        if (this.intGenotypeFieldAccessors.getAccessor(string2) != null) {
            return new BCF2FieldWriter.IGFGenotypesWriter(vCFHeader, bCF2FieldEncoder, this.intGenotypeFieldAccessors.getAccessor(string2));
        }
        if (vCFFormatHeaderLine.getType() == VCFHeaderLineType.Integer) {
            return new BCF2FieldWriter.IntegerTypeGenotypesWriter(vCFHeader, bCF2FieldEncoder);
        }
        return new BCF2FieldWriter.StaticallyTypeGenotypesWriter(vCFHeader, bCF2FieldEncoder);
    }

    public BCF2FieldWriter.SiteWriter getSiteFieldWriter(String string2) {
        return this.getWriter(string2, this.siteWriters);
    }

    public BCF2FieldWriter.GenotypesWriter getGenotypeFieldWriter(String string2) {
        return this.getWriter(string2, this.genotypesWriters);
    }

    @Requires(value={"map != null", "key != null"})
    public <T> T getWriter(String string2, Map<String, T> map2) {
        return map2.get(string2);
    }
}

