/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineIterator;
import org.broadinstitute.variant.vcf.AbstractVCFCodec;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

public class VCFCodec
extends AbstractVCFCodec {
    public static final String VCF4_MAGIC_HEADER = "##fileformat=VCFv4";

    @Override
    public Object readActualHeader(LineIterator lineIterator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (lineIterator.hasNext()) {
            String string2 = lineIterator.peek();
            ++this.lineNo;
            if (string2.startsWith("##")) {
                String[] stringArray = string2.substring(2).split("=");
                if (stringArray.length == 2 && VCFHeaderVersion.isFormatString(stringArray[0])) {
                    if (!VCFHeaderVersion.isVersionString(stringArray[1])) {
                        throw new TribbleException.InvalidHeader(stringArray[1] + " is not a supported version");
                    }
                    bl = true;
                    this.version = VCFHeaderVersion.toHeaderVersion(stringArray[1]);
                    if (this.version == VCFHeaderVersion.VCF3_3 || this.version == VCFHeaderVersion.VCF3_2) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4; please use the VCF3 codec for " + stringArray[1]);
                    }
                    if (this.version != VCFHeaderVersion.VCF4_0 && this.version != VCFHeaderVersion.VCF4_1) {
                        throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4 and does not support " + stringArray[1]);
                    }
                }
                arrayList.add((String)lineIterator.next());
                continue;
            }
            if (string2.startsWith("#")) {
                if (!bl) {
                    throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                }
                arrayList.add((String)lineIterator.next());
                super.parseHeaderFromLines(arrayList, this.version);
                return this.header;
            }
            throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected List<String> parseFilters(String string2) {
        if (string2.equals(".")) {
            return null;
        }
        if (string2.equals("PASS")) {
            return Collections.emptyList();
        }
        if (string2.equals("0")) {
            VCFCodec.generateException("0 is an invalid filter name in vcf4", this.lineNo);
        }
        if (string2.length() == 0) {
            VCFCodec.generateException("The VCF specification requires a valid filter status: filter was " + string2, this.lineNo);
        }
        if (this.filterHash.containsKey(string2)) {
            return (List)this.filterHash.get(string2);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!string2.contains(";")) {
            linkedList.add(string2);
        } else {
            linkedList.addAll(Arrays.asList(string2.split(";")));
        }
        this.filterHash.put(string2, Collections.unmodifiableList(linkedList));
        return linkedList;
    }

    @Override
    public boolean canDecode(String string2) {
        return VCFCodec.canDecodeFile(string2, VCF4_MAGIC_HEADER);
    }
}

