/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.VLSN;

public abstract class VLSNCache {
    public static VLSNCache EMPTY_CACHE = new VLSNCache(){

        public long get(int idx) {
            return VLSN.NULL_VLSN.getSequence();
        }

        public VLSNCache set(int idx, long val, IN parent) {
            if (!parent.getDatabase().getDbEnvironment().getCacheVLSN()) {
                return this;
            }
            if (val == VLSN.NULL_VLSN.getSequence()) {
                return this;
            }
            DefaultCache newCache = new DefaultCache(parent.getMaxEntries(), parent.getDatabase().getDbEnvironment().getCachedVLSNMinLength());
            parent.updateMemorySize(this.getMemorySize(), ((VLSNCache)newCache).getMemorySize());
            return ((VLSNCache)newCache).set(idx, val, parent);
        }

        public VLSNCache copy(int from2, int to2, int n) {
            return this;
        }

        public long getMemorySize() {
            return 0L;
        }
    };

    public abstract long get(int var1);

    public abstract VLSNCache set(int var1, long var2, IN var4);

    public abstract VLSNCache copy(int var1, int var2, int var3);

    public abstract long getMemorySize();

    public static class DefaultCache
    extends VLSNCache {
        private static long[] MAX_VLSN = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE};
        private final byte[] byteArray;
        private final int bytesPerVlsn;

        public DefaultCache(int capacity, int nBytes) {
            assert (capacity >= 1);
            assert (nBytes >= 1);
            assert (nBytes <= 8);
            this.bytesPerVlsn = nBytes;
            this.byteArray = new byte[capacity * this.bytesPerVlsn];
        }

        public DefaultCache(SizeofMarker marker) {
            this.bytesPerVlsn = 0;
            this.byteArray = null;
        }

        public long get(int idx) {
            int i = idx * this.bytesPerVlsn;
            int end = i + this.bytesPerVlsn;
            long val = this.byteArray[i] & 0xFF;
            ++i;
            while (i < end) {
                val <<= 8;
                val |= (long)(this.byteArray[i] & 0xFF);
                ++i;
            }
            if (val == 0L) {
                return VLSN.NULL_VLSN.getSequence();
            }
            return val;
        }

        public DefaultCache set(int idx, long val, IN parent) {
            assert (idx >= 0);
            assert (idx < this.byteArray.length / this.bytesPerVlsn);
            assert (val != 0L);
            if (val == VLSN.NULL_VLSN.getSequence()) {
                val = 0L;
            }
            if (val > MAX_VLSN[this.bytesPerVlsn]) {
                int capacity = this.byteArray.length / this.bytesPerVlsn;
                DefaultCache newCache = new DefaultCache(capacity, this.bytesPerVlsn + 1);
                parent.updateMemorySize(this.getMemorySize(), newCache.getMemorySize());
                newCache = newCache.set(idx, val, parent);
                for (int i = 0; i < capacity; ++i) {
                    if (i == idx) continue;
                    newCache = newCache.set(i, this.get(idx), parent);
                }
                return newCache;
            }
            int i = (idx + 1) * this.bytesPerVlsn - 1;
            int end = i - this.bytesPerVlsn;
            this.byteArray[i] = (byte)(val & 0xFFL);
            --i;
            while (i > end) {
                this.byteArray[i] = (byte)((val >>= 8) & 0xFFL);
                --i;
            }
            assert ((val & 0xFFFFFFFFFFFFFF00L) == 0L) : val;
            return this;
        }

        public DefaultCache copy(int from2, int to2, int n) {
            System.arraycopy(this.byteArray, from2 * this.bytesPerVlsn, this.byteArray, to2 * this.bytesPerVlsn, n * this.bytesPerVlsn);
            return this;
        }

        public long getMemorySize() {
            return MemoryBudget.DEFAULT_VLSN_CACHE_OVERHEAD + MemoryBudget.byteArraySize(this.byteArray.length);
        }
    }
}

