/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class FilterFileReader
implements Iterator<Boolean> {
    private static final int HEADER_SIZE = 12;
    public final int EXPECTED_VERSION = 3;
    private final BinaryFileIterator<Byte> bbIterator;
    public final int version;
    public final long numClusters;
    private static final byte FailedFilter = 0;
    private static final byte PassedFilter = 1;
    private int currentCluster;

    public FilterFileReader(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getByteIterator(12, file);
        ByteBuffer byteBuffer = this.bbIterator.getHeaderBytes();
        for (int i = 0; i < 4; ++i) {
            byte by2 = byteBuffer.get();
            if (by2 == 0) continue;
            throw new PicardException("The first four bytes of a Filter File should be 0 but byte " + i + " was " + by2 + " in file " + file.getAbsolutePath());
        }
        this.version = byteBuffer.getInt();
        if (this.version != 3) {
            throw new PicardException("Expected version is 3 but version found was " + this.version + " in file " + file.getAbsolutePath());
        }
        this.numClusters = UnsignedTypeUtil.uIntToLong(byteBuffer.getInt());
        this.bbIterator.assertTotalElementsEqual(this.numClusters);
        this.currentCluster = 0;
    }

    @Override
    public boolean hasNext() {
        return (long)this.currentCluster < this.numClusters;
    }

    @Override
    public Boolean next() {
        byte by2 = this.bbIterator.next();
        ++this.currentCluster;
        if (by2 == 1) {
            return true;
        }
        if (by2 == 0) {
            return false;
        }
        String string2 = Integer.toHexString(by2);
        string2 = (string2.length() < 2 ? "0x0" : "0x") + string2;
        throw new PicardException("Didn't recognized PF Byte (" + string2 + ")" + " for element (" + this.currentCluster + ") in file(" + this.bbIterator.getFile().getAbsolutePath() + ")");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

