/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.picard.PicardException;
import net.sf.picard.util.ResourceLimitedMap;
import net.sf.picard.util.ResourceLimitedMapFunctor;

public class FileAppendStreamLRUCache
extends ResourceLimitedMap<File, FileOutputStream> {
    public FileAppendStreamLRUCache(int n) {
        super(n, new Functor());
    }

    private static class Functor
    implements ResourceLimitedMapFunctor<File, FileOutputStream> {
        private static final int GC_FREQUENCY = 10000;
        private int numCloses = 0;

        private Functor() {
        }

        @Override
        public FileOutputStream makeValue(File file) {
            try {
                return new FileOutputStream(file, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.gc();
                System.runFinalization();
                try {
                    return new FileOutputStream(file, true);
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    throw new PicardException(file + "not found", fileNotFoundException2);
                }
            }
        }

        @Override
        public void finalizeValue(File file, FileOutputStream fileOutputStream) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new PicardException("Exception closing FileOutputStream for " + file, iOException);
            }
        }
    }
}

