/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sf.picard.PicardException;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class ProcessExecutor {
    private static final Log log = Log.getInstance(ProcessExecutor.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "ProcessExecutor Thread");
        }
    });

    public static int execute(String string2) {
        try {
            Process process = Runtime.getRuntime().exec(string2);
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", string2) + "]", throwable);
        }
    }

    public static int execute(String[] stringArray) {
        return ProcessExecutor.execute(stringArray, null);
    }

    public static int execute(String[] stringArray, String string2) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            if (string2 != null) {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            return ProcessExecutor.readStreamsAndWaitFor(process);
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", stringArray) + "]", throwable);
        }
    }

    public static String executeAndReturnResult(String string2) {
        try {
            Process process = Runtime.getRuntime().exec(string2);
            StringBuilderProcessOutputReader stringBuilderProcessOutputReader = new StringBuilderProcessOutputReader(process.getErrorStream());
            Future<?> future = executorService.submit(stringBuilderProcessOutputReader);
            StringBuilderProcessOutputReader stringBuilderProcessOutputReader2 = new StringBuilderProcessOutputReader(process.getInputStream());
            stringBuilderProcessOutputReader2.run();
            future.get();
            int n = process.waitFor();
            return n == 0 ? stringBuilderProcessOutputReader2.getOutput() : stringBuilderProcessOutputReader.getOutput();
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + string2 + "]", throwable);
        }
    }

    public static ExitStatusAndOutput executeAndReturnInterleavedOutput(String string2) {
        try {
            Process process = Runtime.getRuntime().exec(string2);
            return ProcessExecutor.interleaveProcessOutput(process);
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + string2 + "]", throwable);
        }
    }

    public static ExitStatusAndOutput executeAndReturnInterleavedOutput(String[] stringArray) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            return ProcessExecutor.interleaveProcessOutput(process);
        }
        catch (Throwable throwable) {
            throw new PicardException("Unexpected exception executing [" + StringUtil.join(" ", stringArray) + "]", throwable);
        }
    }

    private static ExitStatusAndOutput interleaveProcessOutput(Process process) throws InterruptedException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        String string3 = null;
        while ((string3 = bufferedReader2.readLine()) != null || (string2 = bufferedReader.readLine()) != null) {
            if (string3 != null) {
                stringBuilder.append(string3).append('\n');
            }
            if (string2 != null) {
                stringBuilder.append(string2).append('\n');
            }
            string3 = null;
            string2 = null;
        }
        return new ExitStatusAndOutput(process.waitFor(), stringBuilder.toString(), null);
    }

    private static int readStreamsAndWaitFor(Process process) throws InterruptedException, ExecutionException {
        Future<?> future = executorService.submit(new LogErrorProcessOutputReader(process.getErrorStream()));
        new LogInfoProcessOutputReader(process.getInputStream()).run();
        future.get();
        return process.waitFor();
    }

    private static class StringBuilderProcessOutputReader
    extends ProcessOutputReader {
        private final StringBuilder sb = new StringBuilder();

        public StringBuilderProcessOutputReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void write(String string2) {
            this.sb.append(string2).append("\n");
        }

        public String getOutput() {
            return this.sb.toString();
        }
    }

    private static class LogInfoProcessOutputReader
    extends ProcessOutputReader {
        public LogInfoProcessOutputReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void write(String string2) {
            log.info(string2);
        }
    }

    private static class LogErrorProcessOutputReader
    extends ProcessOutputReader {
        public LogErrorProcessOutputReader(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        protected void write(String string2) {
            log.error(string2);
        }
    }

    private static abstract class ProcessOutputReader
    implements Runnable {
        private final BufferedReader reader;

        public ProcessOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        @Override
        public void run() {
            try {
                String string2;
                while ((string2 = this.reader.readLine()) != null) {
                    this.write(string2);
                }
            }
            catch (IOException iOException) {
                throw new PicardException("Unexpected exception reading from process stream", iOException);
            }
        }

        protected abstract void write(String var1);
    }

    public static class ExitStatusAndOutput {
        public final int exitStatus;
        public final String stdout;
        public final String stderr;

        public ExitStatusAndOutput(int n, String string2, String string3) {
            this.exitStatus = n;
            this.stdout = string2;
            this.stderr = string3;
        }
    }
}

