/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.LibFileSet;
import org.apache.tools.ant.types.FileSet;

public final class ExtensionUtil {
    private ExtensionUtil() {
    }

    static ArrayList toExtensions(List adapters) throws BuildException {
        ArrayList<Extension> results = new ArrayList<Extension>();
        int size2 = adapters.size();
        for (int i = 0; i < size2; ++i) {
            ExtensionAdapter adapter = (ExtensionAdapter)adapters.get(i);
            Extension extension2 = adapter.toExtension();
            results.add(extension2);
        }
        return results;
    }

    static void extractExtensions(Project project, List libraries, List fileset) throws BuildException {
        if (!fileset.isEmpty()) {
            Extension[] extensions = ExtensionUtil.getExtensions(project, fileset);
            for (int i = 0; i < extensions.length; ++i) {
                libraries.add(extensions[i]);
            }
        }
    }

    private static Extension[] getExtensions(Project project, List libraries) throws BuildException {
        ArrayList extensions = new ArrayList();
        Iterator iterator2 = libraries.iterator();
        while (iterator2.hasNext()) {
            FileSet fileSet = (FileSet)iterator2.next();
            boolean includeImpl = true;
            boolean includeURL = true;
            if (fileSet instanceof LibFileSet) {
                LibFileSet libFileSet = (LibFileSet)fileSet;
                includeImpl = libFileSet.isIncludeImpl();
                includeURL = libFileSet.isIncludeURL();
            }
            DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
            File basedir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(basedir, files[i]);
                ExtensionUtil.loadExtensions(file, extensions, includeImpl, includeURL);
            }
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    private static void loadExtensions(File file, List extensionList, boolean includeImpl, boolean includeURL) throws BuildException {
        try {
            JarFile jarFile = new JarFile(file);
            Extension[] extensions = Extension.getAvailable(jarFile.getManifest());
            for (int i = 0; i < extensions.length; ++i) {
                Extension extension2 = extensions[i];
                ExtensionUtil.addExtension(extensionList, extension2, includeImpl, includeURL);
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), e);
        }
    }

    private static void addExtension(List extensionList, Extension originalExtension, boolean includeImpl, boolean includeURL) {
        boolean hasImplAttributes;
        Extension extension2 = originalExtension;
        if (!includeURL && null != extension2.getImplementationURL()) {
            extension2 = new Extension(extension2.getExtensionName(), extension2.getSpecificationVersion().toString(), extension2.getSpecificationVendor(), extension2.getImplementationVersion().toString(), extension2.getImplementationVendor(), extension2.getImplementationVendorID(), null);
        }
        boolean bl = hasImplAttributes = null != extension2.getImplementationURL() || null != extension2.getImplementationVersion() || null != extension2.getImplementationVendorID() || null != extension2.getImplementationVendor();
        if (!includeImpl && hasImplAttributes) {
            extension2 = new Extension(extension2.getExtensionName(), extension2.getSpecificationVersion().toString(), extension2.getSpecificationVendor(), null, null, null, extension2.getImplementationURL());
        }
        extensionList.add(extension2);
    }

    static Manifest getManifest(File file) throws BuildException {
        try {
            JarFile jarFile = new JarFile(file);
            Manifest m = jarFile.getManifest();
            if (m == null) {
                throw new BuildException(file + " doesn't have a MANIFEST");
            }
            return m;
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), ioe);
        }
    }
}

